/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointParams;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointProvider;
import software.amazon.awssdk.services.iotsitewise.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class IoTSiteWiseResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        IoTSiteWiseEndpointProvider provider = (IoTSiteWiseEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            Endpoint endpoint = provider.resolveEndpoint(IoTSiteWiseResolveEndpointInterceptor.ruleParams(result, executionAttributes)).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = IoTSiteWiseResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static IoTSiteWiseEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        IoTSiteWiseEndpointParams.Builder builder = IoTSiteWiseEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        IoTSiteWiseResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        IoTSiteWiseResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(IoTSiteWiseEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(IoTSiteWiseEndpointParams.Builder params, String operationName) {
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4aAuthScheme.signingRegionSet() != null) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "AssociateAssets": {
                return Optional.of("api.");
            }
            case "AssociateTimeSeriesToAssetProperty": {
                return Optional.of("api.");
            }
            case "BatchAssociateProjectAssets": {
                return Optional.of("monitor.");
            }
            case "BatchDisassociateProjectAssets": {
                return Optional.of("monitor.");
            }
            case "BatchGetAssetPropertyAggregates": {
                return Optional.of("data.");
            }
            case "BatchGetAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "BatchGetAssetPropertyValueHistory": {
                return Optional.of("data.");
            }
            case "BatchPutAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "CreateAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "CreateAsset": {
                return Optional.of("api.");
            }
            case "CreateAssetModel": {
                return Optional.of("api.");
            }
            case "CreateAssetModelCompositeModel": {
                return Optional.of("api.");
            }
            case "CreateBulkImportJob": {
                return Optional.of("data.");
            }
            case "CreateDashboard": {
                return Optional.of("monitor.");
            }
            case "CreateGateway": {
                return Optional.of("api.");
            }
            case "CreatePortal": {
                return Optional.of("monitor.");
            }
            case "CreateProject": {
                return Optional.of("monitor.");
            }
            case "DeleteAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "DeleteAsset": {
                return Optional.of("api.");
            }
            case "DeleteAssetModel": {
                return Optional.of("api.");
            }
            case "DeleteAssetModelCompositeModel": {
                return Optional.of("api.");
            }
            case "DeleteDashboard": {
                return Optional.of("monitor.");
            }
            case "DeleteGateway": {
                return Optional.of("api.");
            }
            case "DeletePortal": {
                return Optional.of("monitor.");
            }
            case "DeleteProject": {
                return Optional.of("monitor.");
            }
            case "DeleteTimeSeries": {
                return Optional.of("api.");
            }
            case "DescribeAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "DescribeAction": {
                return Optional.of("api.");
            }
            case "DescribeAsset": {
                return Optional.of("api.");
            }
            case "DescribeAssetCompositeModel": {
                return Optional.of("api.");
            }
            case "DescribeAssetModel": {
                return Optional.of("api.");
            }
            case "DescribeAssetModelCompositeModel": {
                return Optional.of("api.");
            }
            case "DescribeAssetProperty": {
                return Optional.of("api.");
            }
            case "DescribeBulkImportJob": {
                return Optional.of("data.");
            }
            case "DescribeDashboard": {
                return Optional.of("monitor.");
            }
            case "DescribeDefaultEncryptionConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeGateway": {
                return Optional.of("api.");
            }
            case "DescribeGatewayCapabilityConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeLoggingOptions": {
                return Optional.of("api.");
            }
            case "DescribePortal": {
                return Optional.of("monitor.");
            }
            case "DescribeProject": {
                return Optional.of("monitor.");
            }
            case "DescribeStorageConfiguration": {
                return Optional.of("api.");
            }
            case "DescribeTimeSeries": {
                return Optional.of("api.");
            }
            case "DisassociateAssets": {
                return Optional.of("api.");
            }
            case "DisassociateTimeSeriesFromAssetProperty": {
                return Optional.of("api.");
            }
            case "ExecuteAction": {
                return Optional.of("api.");
            }
            case "ExecuteQuery": {
                return Optional.of("data.");
            }
            case "GetAssetPropertyAggregates": {
                return Optional.of("data.");
            }
            case "GetAssetPropertyValue": {
                return Optional.of("data.");
            }
            case "GetAssetPropertyValueHistory": {
                return Optional.of("data.");
            }
            case "GetInterpolatedAssetPropertyValues": {
                return Optional.of("data.");
            }
            case "ListAccessPolicies": {
                return Optional.of("monitor.");
            }
            case "ListActions": {
                return Optional.of("api.");
            }
            case "ListAssetModelCompositeModels": {
                return Optional.of("api.");
            }
            case "ListAssetModelProperties": {
                return Optional.of("api.");
            }
            case "ListAssetModels": {
                return Optional.of("api.");
            }
            case "ListAssetProperties": {
                return Optional.of("api.");
            }
            case "ListAssetRelationships": {
                return Optional.of("api.");
            }
            case "ListAssets": {
                return Optional.of("api.");
            }
            case "ListAssociatedAssets": {
                return Optional.of("api.");
            }
            case "ListBulkImportJobs": {
                return Optional.of("data.");
            }
            case "ListCompositionRelationships": {
                return Optional.of("api.");
            }
            case "ListDashboards": {
                return Optional.of("monitor.");
            }
            case "ListGateways": {
                return Optional.of("api.");
            }
            case "ListPortals": {
                return Optional.of("monitor.");
            }
            case "ListProjectAssets": {
                return Optional.of("monitor.");
            }
            case "ListProjects": {
                return Optional.of("monitor.");
            }
            case "ListTagsForResource": {
                return Optional.of("api.");
            }
            case "ListTimeSeries": {
                return Optional.of("api.");
            }
            case "PutDefaultEncryptionConfiguration": {
                return Optional.of("api.");
            }
            case "PutLoggingOptions": {
                return Optional.of("api.");
            }
            case "PutStorageConfiguration": {
                return Optional.of("api.");
            }
            case "TagResource": {
                return Optional.of("api.");
            }
            case "UntagResource": {
                return Optional.of("api.");
            }
            case "UpdateAccessPolicy": {
                return Optional.of("monitor.");
            }
            case "UpdateAsset": {
                return Optional.of("api.");
            }
            case "UpdateAssetModel": {
                return Optional.of("api.");
            }
            case "UpdateAssetModelCompositeModel": {
                return Optional.of("api.");
            }
            case "UpdateAssetProperty": {
                return Optional.of("api.");
            }
            case "UpdateDashboard": {
                return Optional.of("monitor.");
            }
            case "UpdateGateway": {
                return Optional.of("api.");
            }
            case "UpdateGatewayCapabilityConfiguration": {
                return Optional.of("api.");
            }
            case "UpdatePortal": {
                return Optional.of("monitor.");
            }
            case "UpdateProject": {
                return Optional.of("monitor.");
            }
        }
        return Optional.empty();
    }
}

