/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetModelCompositeModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateAssetModelCompositeModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelId)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<String> PARENT_ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentAssetModelCompositeModelId").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::parentAssetModelCompositeModelId)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::parentAssetModelCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentAssetModelCompositeModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelExternalId").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelExternalId)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelExternalId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelId").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelId)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelDescription").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelDescription)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelDescription").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelName").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelName)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelType").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelType)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelType").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::clientToken)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> COMPOSED_ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("composedAssetModelId").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::composedAssetModelId)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::composedAssetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("composedAssetModelId").build()}).build();
    private static final SdkField<List<AssetModelPropertyDefinition>> ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModelProperties").getter(CreateAssetModelCompositeModelRequest.getter(CreateAssetModelCompositeModelRequest::assetModelCompositeModelProperties)).setter(CreateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, PARENT_ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD, ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD, CLIENT_TOKEN_FIELD, COMPOSED_ASSET_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD));
    private final String assetModelId;
    private final String parentAssetModelCompositeModelId;
    private final String assetModelCompositeModelExternalId;
    private final String assetModelCompositeModelId;
    private final String assetModelCompositeModelDescription;
    private final String assetModelCompositeModelName;
    private final String assetModelCompositeModelType;
    private final String clientToken;
    private final String composedAssetModelId;
    private final List<AssetModelPropertyDefinition> assetModelCompositeModelProperties;

    private CreateAssetModelCompositeModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.parentAssetModelCompositeModelId = builder.parentAssetModelCompositeModelId;
        this.assetModelCompositeModelExternalId = builder.assetModelCompositeModelExternalId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelDescription = builder.assetModelCompositeModelDescription;
        this.assetModelCompositeModelName = builder.assetModelCompositeModelName;
        this.assetModelCompositeModelType = builder.assetModelCompositeModelType;
        this.clientToken = builder.clientToken;
        this.composedAssetModelId = builder.composedAssetModelId;
        this.assetModelCompositeModelProperties = builder.assetModelCompositeModelProperties;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String parentAssetModelCompositeModelId() {
        return this.parentAssetModelCompositeModelId;
    }

    public final String assetModelCompositeModelExternalId() {
        return this.assetModelCompositeModelExternalId;
    }

    public final String assetModelCompositeModelId() {
        return this.assetModelCompositeModelId;
    }

    public final String assetModelCompositeModelDescription() {
        return this.assetModelCompositeModelDescription;
    }

    public final String assetModelCompositeModelName() {
        return this.assetModelCompositeModelName;
    }

    public final String assetModelCompositeModelType() {
        return this.assetModelCompositeModelType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String composedAssetModelId() {
        return this.composedAssetModelId;
    }

    public final boolean hasAssetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties != null && !(this.assetModelCompositeModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelPropertyDefinition> assetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAssetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.composedAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetModelCompositeModelRequest)) {
            return false;
        }
        CreateAssetModelCompositeModelRequest other = (CreateAssetModelCompositeModelRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.parentAssetModelCompositeModelId(), other.parentAssetModelCompositeModelId()) && Objects.equals(this.assetModelCompositeModelExternalId(), other.assetModelCompositeModelExternalId()) && Objects.equals(this.assetModelCompositeModelId(), other.assetModelCompositeModelId()) && Objects.equals(this.assetModelCompositeModelDescription(), other.assetModelCompositeModelDescription()) && Objects.equals(this.assetModelCompositeModelName(), other.assetModelCompositeModelName()) && Objects.equals(this.assetModelCompositeModelType(), other.assetModelCompositeModelType()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.composedAssetModelId(), other.composedAssetModelId()) && this.hasAssetModelCompositeModelProperties() == other.hasAssetModelCompositeModelProperties() && Objects.equals(this.assetModelCompositeModelProperties(), other.assetModelCompositeModelProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetModelCompositeModelRequest").add("AssetModelId", (Object)this.assetModelId()).add("ParentAssetModelCompositeModelId", (Object)this.parentAssetModelCompositeModelId()).add("AssetModelCompositeModelExternalId", (Object)this.assetModelCompositeModelExternalId()).add("AssetModelCompositeModelId", (Object)this.assetModelCompositeModelId()).add("AssetModelCompositeModelDescription", (Object)this.assetModelCompositeModelDescription()).add("AssetModelCompositeModelName", (Object)this.assetModelCompositeModelName()).add("AssetModelCompositeModelType", (Object)this.assetModelCompositeModelType()).add("ClientToken", (Object)this.clientToken()).add("ComposedAssetModelId", (Object)this.composedAssetModelId()).add("AssetModelCompositeModelProperties", this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "parentAssetModelCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.parentAssetModelCompositeModelId()));
            }
            case "assetModelCompositeModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelExternalId()));
            }
            case "assetModelCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelId()));
            }
            case "assetModelCompositeModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelDescription()));
            }
            case "assetModelCompositeModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelName()));
            }
            case "assetModelCompositeModelType": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelType()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "composedAssetModelId": {
                return Optional.ofNullable(clazz.cast(this.composedAssetModelId()));
            }
            case "assetModelCompositeModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetModelCompositeModelRequest, T> g) {
        return obj -> g.apply((CreateAssetModelCompositeModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String parentAssetModelCompositeModelId;
        private String assetModelCompositeModelExternalId;
        private String assetModelCompositeModelId;
        private String assetModelCompositeModelDescription;
        private String assetModelCompositeModelName;
        private String assetModelCompositeModelType;
        private String clientToken;
        private String composedAssetModelId;
        private List<AssetModelPropertyDefinition> assetModelCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetModelCompositeModelRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.parentAssetModelCompositeModelId(model.parentAssetModelCompositeModelId);
            this.assetModelCompositeModelExternalId(model.assetModelCompositeModelExternalId);
            this.assetModelCompositeModelId(model.assetModelCompositeModelId);
            this.assetModelCompositeModelDescription(model.assetModelCompositeModelDescription);
            this.assetModelCompositeModelName(model.assetModelCompositeModelName);
            this.assetModelCompositeModelType(model.assetModelCompositeModelType);
            this.clientToken(model.clientToken);
            this.composedAssetModelId(model.composedAssetModelId);
            this.assetModelCompositeModelProperties(model.assetModelCompositeModelProperties);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getParentAssetModelCompositeModelId() {
            return this.parentAssetModelCompositeModelId;
        }

        public final void setParentAssetModelCompositeModelId(String parentAssetModelCompositeModelId) {
            this.parentAssetModelCompositeModelId = parentAssetModelCompositeModelId;
        }

        @Override
        public final Builder parentAssetModelCompositeModelId(String parentAssetModelCompositeModelId) {
            this.parentAssetModelCompositeModelId = parentAssetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelExternalId() {
            return this.assetModelCompositeModelExternalId;
        }

        public final void setAssetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
        }

        @Override
        public final Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return this.assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelDescription() {
            return this.assetModelCompositeModelDescription;
        }

        public final void setAssetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
        }

        @Override
        public final Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
            return this;
        }

        public final String getAssetModelCompositeModelName() {
            return this.assetModelCompositeModelName;
        }

        public final void setAssetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
        }

        @Override
        public final Builder assetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
            return this;
        }

        public final String getAssetModelCompositeModelType() {
            return this.assetModelCompositeModelType;
        }

        public final void setAssetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
        }

        @Override
        public final Builder assetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getComposedAssetModelId() {
            return this.composedAssetModelId;
        }

        public final void setComposedAssetModelId(String composedAssetModelId) {
            this.composedAssetModelId = composedAssetModelId;
        }

        @Override
        public final Builder composedAssetModelId(String composedAssetModelId) {
            this.composedAssetModelId = composedAssetModelId;
            return this;
        }

        public final List<AssetModelPropertyDefinition.Builder> getAssetModelCompositeModelProperties() {
            List<AssetModelPropertyDefinition.Builder> result = AssetModelPropertyDefinitionsCopier.copyToBuilder(this.assetModelCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelProperties(Collection<AssetModelPropertyDefinition.BuilderImpl> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertyDefinitionsCopier.copyFromBuilder(assetModelCompositeModelProperties);
        }

        @Override
        public final Builder assetModelCompositeModelProperties(Collection<AssetModelPropertyDefinition> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertyDefinitionsCopier.copy(assetModelCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(AssetModelPropertyDefinition ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Arrays.asList(assetModelCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Stream.of(assetModelCompositeModelProperties).map(c -> (AssetModelPropertyDefinition)((AssetModelPropertyDefinition.Builder)AssetModelPropertyDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetModelCompositeModelRequest build() {
            return new CreateAssetModelCompositeModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetModelCompositeModelRequest> {
        public Builder assetModelId(String var1);

        public Builder parentAssetModelCompositeModelId(String var1);

        public Builder assetModelCompositeModelExternalId(String var1);

        public Builder assetModelCompositeModelId(String var1);

        public Builder assetModelCompositeModelDescription(String var1);

        public Builder assetModelCompositeModelName(String var1);

        public Builder assetModelCompositeModelType(String var1);

        public Builder clientToken(String var1);

        public Builder composedAssetModelId(String var1);

        public Builder assetModelCompositeModelProperties(Collection<AssetModelPropertyDefinition> var1);

        public Builder assetModelCompositeModelProperties(AssetModelPropertyDefinition ... var1);

        public Builder assetModelCompositeModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

