/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssetModelCompositeModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateAssetModelCompositeModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelId)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelId").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelId)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelCompositeModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelExternalId").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelExternalId)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelExternalId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelDescription").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelDescription)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelDescription").build()}).build();
    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelCompositeModelName").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelName)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::clientToken)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModelProperties").getter(UpdateAssetModelCompositeModelRequest.getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelProperties)).setter(UpdateAssetModelCompositeModelRequest.setter(Builder::assetModelCompositeModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD, CLIENT_TOKEN_FIELD, ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD));
    private final String assetModelId;
    private final String assetModelCompositeModelId;
    private final String assetModelCompositeModelExternalId;
    private final String assetModelCompositeModelDescription;
    private final String assetModelCompositeModelName;
    private final String clientToken;
    private final List<AssetModelProperty> assetModelCompositeModelProperties;

    private UpdateAssetModelCompositeModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelExternalId = builder.assetModelCompositeModelExternalId;
        this.assetModelCompositeModelDescription = builder.assetModelCompositeModelDescription;
        this.assetModelCompositeModelName = builder.assetModelCompositeModelName;
        this.clientToken = builder.clientToken;
        this.assetModelCompositeModelProperties = builder.assetModelCompositeModelProperties;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelCompositeModelId() {
        return this.assetModelCompositeModelId;
    }

    public final String assetModelCompositeModelExternalId() {
        return this.assetModelCompositeModelExternalId;
    }

    public final String assetModelCompositeModelDescription() {
        return this.assetModelCompositeModelDescription;
    }

    public final String assetModelCompositeModelName() {
        return this.assetModelCompositeModelName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasAssetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties != null && !(this.assetModelCompositeModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetModelProperty> assetModelCompositeModelProperties() {
        return this.assetModelCompositeModelProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetModelCompositeModelRequest)) {
            return false;
        }
        UpdateAssetModelCompositeModelRequest other = (UpdateAssetModelCompositeModelRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelCompositeModelId(), other.assetModelCompositeModelId()) && Objects.equals(this.assetModelCompositeModelExternalId(), other.assetModelCompositeModelExternalId()) && Objects.equals(this.assetModelCompositeModelDescription(), other.assetModelCompositeModelDescription()) && Objects.equals(this.assetModelCompositeModelName(), other.assetModelCompositeModelName()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasAssetModelCompositeModelProperties() == other.hasAssetModelCompositeModelProperties() && Objects.equals(this.assetModelCompositeModelProperties(), other.assetModelCompositeModelProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssetModelCompositeModelRequest").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelCompositeModelId", (Object)this.assetModelCompositeModelId()).add("AssetModelCompositeModelExternalId", (Object)this.assetModelCompositeModelExternalId()).add("AssetModelCompositeModelDescription", (Object)this.assetModelCompositeModelDescription()).add("AssetModelCompositeModelName", (Object)this.assetModelCompositeModelName()).add("ClientToken", (Object)this.clientToken()).add("AssetModelCompositeModelProperties", this.hasAssetModelCompositeModelProperties() ? this.assetModelCompositeModelProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelId()));
            }
            case "assetModelCompositeModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelExternalId()));
            }
            case "assetModelCompositeModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelDescription()));
            }
            case "assetModelCompositeModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assetModelCompositeModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModelProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetModelCompositeModelRequest, T> g) {
        return obj -> g.apply((UpdateAssetModelCompositeModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelCompositeModelId;
        private String assetModelCompositeModelExternalId;
        private String assetModelCompositeModelDescription;
        private String assetModelCompositeModelName;
        private String clientToken;
        private List<AssetModelProperty> assetModelCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetModelCompositeModelRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.assetModelCompositeModelId(model.assetModelCompositeModelId);
            this.assetModelCompositeModelExternalId(model.assetModelCompositeModelExternalId);
            this.assetModelCompositeModelDescription(model.assetModelCompositeModelDescription);
            this.assetModelCompositeModelName(model.assetModelCompositeModelName);
            this.clientToken(model.clientToken);
            this.assetModelCompositeModelProperties(model.assetModelCompositeModelProperties);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return this.assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelExternalId() {
            return this.assetModelCompositeModelExternalId;
        }

        public final void setAssetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
        }

        @Override
        public final Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
            return this;
        }

        public final String getAssetModelCompositeModelDescription() {
            return this.assetModelCompositeModelDescription;
        }

        public final void setAssetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
        }

        @Override
        public final Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
            return this;
        }

        public final String getAssetModelCompositeModelName() {
            return this.assetModelCompositeModelName;
        }

        public final void setAssetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
        }

        @Override
        public final Builder assetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelCompositeModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier.copyToBuilder(this.assetModelCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelCompositeModelProperties);
        }

        @Override
        public final Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copy(assetModelCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(AssetModelProperty ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Arrays.asList(assetModelCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder> ... assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties(Stream.of(assetModelCompositeModelProperties).map(c -> (AssetModelProperty)((AssetModelProperty.Builder)AssetModelProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetModelCompositeModelRequest build() {
            return new UpdateAssetModelCompositeModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssetModelCompositeModelRequest> {
        public Builder assetModelId(String var1);

        public Builder assetModelCompositeModelId(String var1);

        public Builder assetModelCompositeModelExternalId(String var1);

        public Builder assetModelCompositeModelDescription(String var1);

        public Builder assetModelCompositeModelName(String var1);

        public Builder clientToken(String var1);

        public Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> var1);

        public Builder assetModelCompositeModelProperties(AssetModelProperty ... var1);

        public Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

