/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;

public class ListProjectAssetsIterable
implements SdkIterable<ListProjectAssetsResponse> {
    private final IoTSiteWiseClient client;
    private final ListProjectAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectAssetsIterable(IoTSiteWiseClient client, ListProjectAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProjectAssetsResponseFetcher();
    }

    public Iterator<ListProjectAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> assetIds() {
        Function<ListProjectAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetIds() != null) {
                return response.assetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProjectAssetsResponseFetcher
    implements SyncPageFetcher<ListProjectAssetsResponse> {
        private ListProjectAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProjectAssetsResponse nextPage(ListProjectAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectAssetsIterable.this.client.listProjectAssets(ListProjectAssetsIterable.this.firstRequest);
            }
            return ListProjectAssetsIterable.this.client.listProjectAssets((ListProjectAssetsRequest)((Object)ListProjectAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

