/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeProjectResponse> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectId)).setter(DescribeProjectResponse.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectArn)).setter(DescribeProjectResponse.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectName)).setter(DescribeProjectResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalId").getter(DescribeProjectResponse.getter(DescribeProjectResponse::portalId)).setter(DescribeProjectResponse.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectDescription").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectDescription)).setter(DescribeProjectResponse.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build()}).build();
    private static final SdkField<Instant> PROJECT_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("projectCreationDate").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectCreationDate)).setter(DescribeProjectResponse.setter(Builder::projectCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectCreationDate").build()}).build();
    private static final SdkField<Instant> PROJECT_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("projectLastUpdateDate").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectLastUpdateDate)).setter(DescribeProjectResponse.setter(Builder::projectLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectLastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, PROJECT_ARN_FIELD, PROJECT_NAME_FIELD, PORTAL_ID_FIELD, PROJECT_DESCRIPTION_FIELD, PROJECT_CREATION_DATE_FIELD, PROJECT_LAST_UPDATE_DATE_FIELD));
    private final String projectId;
    private final String projectArn;
    private final String projectName;
    private final String portalId;
    private final String projectDescription;
    private final Instant projectCreationDate;
    private final Instant projectLastUpdateDate;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.portalId = builder.portalId;
        this.projectDescription = builder.projectDescription;
        this.projectCreationDate = builder.projectCreationDate;
        this.projectLastUpdateDate = builder.projectLastUpdateDate;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String portalId() {
        return this.portalId;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final Instant projectCreationDate() {
        return this.projectCreationDate;
    }

    public final Instant projectLastUpdateDate() {
        return this.projectLastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectLastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.projectCreationDate(), other.projectCreationDate()) && Objects.equals(this.projectLastUpdateDate(), other.projectLastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectResponse").add("ProjectId", (Object)this.projectId()).add("ProjectArn", (Object)this.projectArn()).add("ProjectName", (Object)this.projectName()).add("PortalId", (Object)this.portalId()).add("ProjectDescription", (Object)this.projectDescription()).add("ProjectCreationDate", (Object)this.projectCreationDate()).add("ProjectLastUpdateDate", (Object)this.projectLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "portalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "projectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "projectCreationDate": {
                return Optional.ofNullable(clazz.cast(this.projectCreationDate()));
            }
            case "projectLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.projectLastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String projectId;
        private String projectArn;
        private String projectName;
        private String portalId;
        private String projectDescription;
        private Instant projectCreationDate;
        private Instant projectLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            this.projectId(model.projectId);
            this.projectArn(model.projectArn);
            this.projectName(model.projectName);
            this.portalId(model.portalId);
            this.projectDescription(model.projectDescription);
            this.projectCreationDate(model.projectCreationDate);
            this.projectLastUpdateDate(model.projectLastUpdateDate);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPortalId() {
            return this.portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final Instant getProjectCreationDate() {
            return this.projectCreationDate;
        }

        public final void setProjectCreationDate(Instant projectCreationDate) {
            this.projectCreationDate = projectCreationDate;
        }

        @Override
        public final Builder projectCreationDate(Instant projectCreationDate) {
            this.projectCreationDate = projectCreationDate;
            return this;
        }

        public final Instant getProjectLastUpdateDate() {
            return this.projectLastUpdateDate;
        }

        public final void setProjectLastUpdateDate(Instant projectLastUpdateDate) {
            this.projectLastUpdateDate = projectLastUpdateDate;
        }

        @Override
        public final Builder projectLastUpdateDate(Instant projectLastUpdateDate) {
            this.projectLastUpdateDate = projectLastUpdateDate;
            return this;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectResponse> {
        public Builder projectId(String var1);

        public Builder projectArn(String var1);

        public Builder projectName(String var1);

        public Builder portalId(String var1);

        public Builder projectDescription(String var1);

        public Builder projectCreationDate(Instant var1);

        public Builder projectLastUpdateDate(Instant var1);
    }
}

