/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ExpressionVariable;
import software.amazon.awssdk.services.iotsitewise.model.ExpressionVariablesCopier;
import software.amazon.awssdk.services.iotsitewise.model.TransformProcessingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transform> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(Transform.getter(Transform::expression)).setter(Transform.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<List<ExpressionVariable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(Transform.getter(Transform::variables)).setter(Transform.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpressionVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TransformProcessingConfig> PROCESSING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("processingConfig").getter(Transform.getter(Transform::processingConfig)).setter(Transform.setter(Builder::processingConfig)).constructor(TransformProcessingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, VARIABLES_FIELD, PROCESSING_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final List<ExpressionVariable> variables;
    private final TransformProcessingConfig processingConfig;

    private Transform(BuilderImpl builder) {
        this.expression = builder.expression;
        this.variables = builder.variables;
        this.processingConfig = builder.processingConfig;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<ExpressionVariable> variables() {
        return this.variables;
    }

    public final TransformProcessingConfig processingConfig() {
        return this.processingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transform)) {
            return false;
        }
        Transform other = (Transform)obj;
        return Objects.equals(this.expression(), other.expression()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.processingConfig(), other.processingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Transform").add("Expression", (Object)this.expression()).add("Variables", this.hasVariables() ? this.variables() : null).add("ProcessingConfig", (Object)this.processingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "processingConfig": {
                return Optional.ofNullable(clazz.cast(this.processingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transform, T> g) {
        return obj -> g.apply((Transform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private List<ExpressionVariable> variables = DefaultSdkAutoConstructList.getInstance();
        private TransformProcessingConfig processingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Transform model) {
            this.expression(model.expression);
            this.variables(model.variables);
            this.processingConfig(model.processingConfig);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final List<ExpressionVariable.Builder> getVariables() {
            List<ExpressionVariable.Builder> result = ExpressionVariablesCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<ExpressionVariable.BuilderImpl> variables) {
            this.variables = ExpressionVariablesCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<ExpressionVariable> variables) {
            this.variables = ExpressionVariablesCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(ExpressionVariable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<ExpressionVariable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (ExpressionVariable)((ExpressionVariable.Builder)ExpressionVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TransformProcessingConfig.Builder getProcessingConfig() {
            return this.processingConfig != null ? this.processingConfig.toBuilder() : null;
        }

        public final void setProcessingConfig(TransformProcessingConfig.BuilderImpl processingConfig) {
            this.processingConfig = processingConfig != null ? processingConfig.build() : null;
        }

        @Override
        public final Builder processingConfig(TransformProcessingConfig processingConfig) {
            this.processingConfig = processingConfig;
            return this;
        }

        public Transform build() {
            return new Transform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transform> {
        public Builder expression(String var1);

        public Builder variables(Collection<ExpressionVariable> var1);

        public Builder variables(ExpressionVariable ... var1);

        public Builder variables(Consumer<ExpressionVariable.Builder> ... var1);

        public Builder processingConfig(TransformProcessingConfig var1);

        default public Builder processingConfig(Consumer<TransformProcessingConfig.Builder> processingConfig) {
            return this.processingConfig((TransformProcessingConfig)((TransformProcessingConfig.Builder)TransformProcessingConfig.builder().applyMutation(processingConfig)).build());
        }
    }
}

