/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Quality {
    GOOD("GOOD"),
    BAD("BAD"),
    UNCERTAIN("UNCERTAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Quality> VALUE_MAP;
    private final String value;

    private Quality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Quality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Quality> knownValues() {
        EnumSet<Quality> knownValues = EnumSet.allOf(Quality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Quality.class, Quality::toString);
    }
}

