/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotsitewise.DefaultIoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.DefaultIoTSiteWiseBaseClientBuilder;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClientBuilder;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseServiceClientConfiguration;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointProvider;

@SdkInternalApi
final class DefaultIoTSiteWiseAsyncClientBuilder
extends DefaultIoTSiteWiseBaseClientBuilder<IoTSiteWiseAsyncClientBuilder, IoTSiteWiseAsyncClient>
implements IoTSiteWiseAsyncClientBuilder {
    DefaultIoTSiteWiseAsyncClientBuilder() {
    }

    @Override
    public DefaultIoTSiteWiseAsyncClientBuilder endpointProvider(IoTSiteWiseEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTSiteWiseAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIoTSiteWiseAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IoTSiteWiseServiceClientConfiguration serviceClientConfiguration = IoTSiteWiseServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIoTSiteWiseAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

