/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue;

public class GetInterpolatedAssetPropertyValuesIterable
implements SdkIterable<GetInterpolatedAssetPropertyValuesResponse> {
    private final IoTSiteWiseClient client;
    private final GetInterpolatedAssetPropertyValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInterpolatedAssetPropertyValuesIterable(IoTSiteWiseClient client, GetInterpolatedAssetPropertyValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetInterpolatedAssetPropertyValuesResponseFetcher();
    }

    public Iterator<GetInterpolatedAssetPropertyValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InterpolatedAssetPropertyValue> interpolatedAssetPropertyValues() {
        Function<GetInterpolatedAssetPropertyValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.interpolatedAssetPropertyValues() != null) {
                return response.interpolatedAssetPropertyValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetInterpolatedAssetPropertyValuesResponseFetcher
    implements SyncPageFetcher<GetInterpolatedAssetPropertyValuesResponse> {
        private GetInterpolatedAssetPropertyValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetInterpolatedAssetPropertyValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInterpolatedAssetPropertyValuesResponse nextPage(GetInterpolatedAssetPropertyValuesResponse previousPage) {
            if (previousPage == null) {
                return GetInterpolatedAssetPropertyValuesIterable.this.client.getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesIterable.this.firstRequest);
            }
            return GetInterpolatedAssetPropertyValuesIterable.this.client.getInterpolatedAssetPropertyValues((GetInterpolatedAssetPropertyValuesRequest)((Object)GetInterpolatedAssetPropertyValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

