/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchGetAssetPropertyValueHistoryErrorEntriesCopier {
    static List<BatchGetAssetPropertyValueHistoryErrorEntry> copy(
            Collection<? extends BatchGetAssetPropertyValueHistoryErrorEntry> batchGetAssetPropertyValueHistoryErrorEntriesParam) {
        List<BatchGetAssetPropertyValueHistoryErrorEntry> list;
        if (batchGetAssetPropertyValueHistoryErrorEntriesParam == null
                || batchGetAssetPropertyValueHistoryErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyValueHistoryErrorEntry> modifiableList = new ArrayList<>();
            batchGetAssetPropertyValueHistoryErrorEntriesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchGetAssetPropertyValueHistoryErrorEntry> copyFromBuilder(
            Collection<? extends BatchGetAssetPropertyValueHistoryErrorEntry.Builder> batchGetAssetPropertyValueHistoryErrorEntriesParam) {
        List<BatchGetAssetPropertyValueHistoryErrorEntry> list;
        if (batchGetAssetPropertyValueHistoryErrorEntriesParam == null
                || batchGetAssetPropertyValueHistoryErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyValueHistoryErrorEntry> modifiableList = new ArrayList<>();
            batchGetAssetPropertyValueHistoryErrorEntriesParam.forEach(entry -> {
                BatchGetAssetPropertyValueHistoryErrorEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> copyToBuilder(
            Collection<? extends BatchGetAssetPropertyValueHistoryErrorEntry> batchGetAssetPropertyValueHistoryErrorEntriesParam) {
        List<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> list;
        if (batchGetAssetPropertyValueHistoryErrorEntriesParam == null
                || batchGetAssetPropertyValueHistoryErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> modifiableList = new ArrayList<>();
            batchGetAssetPropertyValueHistoryErrorEntriesParam.forEach(entry -> {
                BatchGetAssetPropertyValueHistoryErrorEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
