/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValue;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;

public class GetAssetPropertyAggregatesIterable
implements SdkIterable<GetAssetPropertyAggregatesResponse> {
    private final IoTSiteWiseClient client;
    private final GetAssetPropertyAggregatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAssetPropertyAggregatesIterable(IoTSiteWiseClient client, GetAssetPropertyAggregatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAssetPropertyAggregatesResponseFetcher();
    }

    public Iterator<GetAssetPropertyAggregatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregatedValue> aggregatedValues() {
        Function<GetAssetPropertyAggregatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregatedValues() != null) {
                return response.aggregatedValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAssetPropertyAggregatesResponseFetcher
    implements SyncPageFetcher<GetAssetPropertyAggregatesResponse> {
        private GetAssetPropertyAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(GetAssetPropertyAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAssetPropertyAggregatesResponse nextPage(GetAssetPropertyAggregatesResponse previousPage) {
            if (previousPage == null) {
                return GetAssetPropertyAggregatesIterable.this.client.getAssetPropertyAggregates(GetAssetPropertyAggregatesIterable.this.firstRequest);
            }
            return GetAssetPropertyAggregatesIterable.this.client.getAssetPropertyAggregates((GetAssetPropertyAggregatesRequest)((Object)GetAssetPropertyAggregatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

