/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInterpolatedAssetPropertyValuesRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, GetInterpolatedAssetPropertyValuesRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::assetId)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::propertyId)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::propertyAlias)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()}).build();
    private static final SdkField<Long> START_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTimeInSeconds").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::startTimeInSeconds)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::startTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTimeInSeconds").build()}).build();
    private static final SdkField<Integer> START_TIME_OFFSET_IN_NANOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startTimeOffsetInNanos").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::startTimeOffsetInNanos)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::startTimeOffsetInNanos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTimeOffsetInNanos").build()}).build();
    private static final SdkField<Long> END_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTimeInSeconds").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::endTimeInSeconds)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::endTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTimeInSeconds").build()}).build();
    private static final SdkField<Integer> END_TIME_OFFSET_IN_NANOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("endTimeOffsetInNanos").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::endTimeOffsetInNanos)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::endTimeOffsetInNanos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTimeOffsetInNanos").build()}).build();
    private static final SdkField<String> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quality").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::qualityAsString)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::quality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("quality").build()}).build();
    private static final SdkField<Long> INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("intervalInSeconds").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::intervalInSeconds)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::intervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("intervalInSeconds").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::nextToken)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::maxResults)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::type)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final SdkField<Long> INTERVAL_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("intervalWindowInSeconds").getter(GetInterpolatedAssetPropertyValuesRequest.getter(GetInterpolatedAssetPropertyValuesRequest::intervalWindowInSeconds)).setter(GetInterpolatedAssetPropertyValuesRequest.setter(Builder::intervalWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("intervalWindowInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, START_TIME_IN_SECONDS_FIELD, START_TIME_OFFSET_IN_NANOS_FIELD, END_TIME_IN_SECONDS_FIELD, END_TIME_OFFSET_IN_NANOS_FIELD, QUALITY_FIELD, INTERVAL_IN_SECONDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TYPE_FIELD, INTERVAL_WINDOW_IN_SECONDS_FIELD));
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final Long startTimeInSeconds;
    private final Integer startTimeOffsetInNanos;
    private final Long endTimeInSeconds;
    private final Integer endTimeOffsetInNanos;
    private final String quality;
    private final Long intervalInSeconds;
    private final String nextToken;
    private final Integer maxResults;
    private final String type;
    private final Long intervalWindowInSeconds;

    private GetInterpolatedAssetPropertyValuesRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.startTimeInSeconds = builder.startTimeInSeconds;
        this.startTimeOffsetInNanos = builder.startTimeOffsetInNanos;
        this.endTimeInSeconds = builder.endTimeInSeconds;
        this.endTimeOffsetInNanos = builder.endTimeOffsetInNanos;
        this.quality = builder.quality;
        this.intervalInSeconds = builder.intervalInSeconds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.type = builder.type;
        this.intervalWindowInSeconds = builder.intervalWindowInSeconds;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String propertyAlias() {
        return this.propertyAlias;
    }

    public final Long startTimeInSeconds() {
        return this.startTimeInSeconds;
    }

    public final Integer startTimeOffsetInNanos() {
        return this.startTimeOffsetInNanos;
    }

    public final Long endTimeInSeconds() {
        return this.endTimeInSeconds;
    }

    public final Integer endTimeOffsetInNanos() {
        return this.endTimeOffsetInNanos;
    }

    public final Quality quality() {
        return Quality.fromValue(this.quality);
    }

    public final String qualityAsString() {
        return this.quality;
    }

    public final Long intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String type() {
        return this.type;
    }

    public final Long intervalWindowInSeconds() {
        return this.intervalWindowInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeOffsetInNanos());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeOffsetInNanos());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalWindowInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInterpolatedAssetPropertyValuesRequest)) {
            return false;
        }
        GetInterpolatedAssetPropertyValuesRequest other = (GetInterpolatedAssetPropertyValuesRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && Objects.equals(this.startTimeInSeconds(), other.startTimeInSeconds()) && Objects.equals(this.startTimeOffsetInNanos(), other.startTimeOffsetInNanos()) && Objects.equals(this.endTimeInSeconds(), other.endTimeInSeconds()) && Objects.equals(this.endTimeOffsetInNanos(), other.endTimeOffsetInNanos()) && Objects.equals(this.qualityAsString(), other.qualityAsString()) && Objects.equals(this.intervalInSeconds(), other.intervalInSeconds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.intervalWindowInSeconds(), other.intervalWindowInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"GetInterpolatedAssetPropertyValuesRequest").add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("StartTimeInSeconds", (Object)this.startTimeInSeconds()).add("StartTimeOffsetInNanos", (Object)this.startTimeOffsetInNanos()).add("EndTimeInSeconds", (Object)this.endTimeInSeconds()).add("EndTimeOffsetInNanos", (Object)this.endTimeOffsetInNanos()).add("Quality", (Object)this.qualityAsString()).add("IntervalInSeconds", (Object)this.intervalInSeconds()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Type", (Object)this.type()).add("IntervalWindowInSeconds", (Object)this.intervalWindowInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "startTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.startTimeInSeconds()));
            }
            case "startTimeOffsetInNanos": {
                return Optional.ofNullable(clazz.cast(this.startTimeOffsetInNanos()));
            }
            case "endTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.endTimeInSeconds()));
            }
            case "endTimeOffsetInNanos": {
                return Optional.ofNullable(clazz.cast(this.endTimeOffsetInNanos()));
            }
            case "quality": {
                return Optional.ofNullable(clazz.cast(this.qualityAsString()));
            }
            case "intervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.intervalInSeconds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "intervalWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.intervalWindowInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInterpolatedAssetPropertyValuesRequest, T> g) {
        return obj -> g.apply((GetInterpolatedAssetPropertyValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private Long startTimeInSeconds;
        private Integer startTimeOffsetInNanos;
        private Long endTimeInSeconds;
        private Integer endTimeOffsetInNanos;
        private String quality;
        private Long intervalInSeconds;
        private String nextToken;
        private Integer maxResults;
        private String type;
        private Long intervalWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInterpolatedAssetPropertyValuesRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.startTimeInSeconds(model.startTimeInSeconds);
            this.startTimeOffsetInNanos(model.startTimeOffsetInNanos);
            this.endTimeInSeconds(model.endTimeInSeconds);
            this.endTimeOffsetInNanos(model.endTimeOffsetInNanos);
            this.quality(model.quality);
            this.intervalInSeconds(model.intervalInSeconds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.type(model.type);
            this.intervalWindowInSeconds(model.intervalWindowInSeconds);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        @Transient
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        @Transient
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        @Transient
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final Long getStartTimeInSeconds() {
            return this.startTimeInSeconds;
        }

        public final void setStartTimeInSeconds(Long startTimeInSeconds) {
            this.startTimeInSeconds = startTimeInSeconds;
        }

        @Override
        @Transient
        public final Builder startTimeInSeconds(Long startTimeInSeconds) {
            this.startTimeInSeconds = startTimeInSeconds;
            return this;
        }

        public final Integer getStartTimeOffsetInNanos() {
            return this.startTimeOffsetInNanos;
        }

        public final void setStartTimeOffsetInNanos(Integer startTimeOffsetInNanos) {
            this.startTimeOffsetInNanos = startTimeOffsetInNanos;
        }

        @Override
        @Transient
        public final Builder startTimeOffsetInNanos(Integer startTimeOffsetInNanos) {
            this.startTimeOffsetInNanos = startTimeOffsetInNanos;
            return this;
        }

        public final Long getEndTimeInSeconds() {
            return this.endTimeInSeconds;
        }

        public final void setEndTimeInSeconds(Long endTimeInSeconds) {
            this.endTimeInSeconds = endTimeInSeconds;
        }

        @Override
        @Transient
        public final Builder endTimeInSeconds(Long endTimeInSeconds) {
            this.endTimeInSeconds = endTimeInSeconds;
            return this;
        }

        public final Integer getEndTimeOffsetInNanos() {
            return this.endTimeOffsetInNanos;
        }

        public final void setEndTimeOffsetInNanos(Integer endTimeOffsetInNanos) {
            this.endTimeOffsetInNanos = endTimeOffsetInNanos;
        }

        @Override
        @Transient
        public final Builder endTimeOffsetInNanos(Integer endTimeOffsetInNanos) {
            this.endTimeOffsetInNanos = endTimeOffsetInNanos;
            return this;
        }

        public final String getQuality() {
            return this.quality;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        @Override
        @Transient
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        @Transient
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final Long getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        public final void setIntervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        @Transient
        public final Builder intervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Long getIntervalWindowInSeconds() {
            return this.intervalWindowInSeconds;
        }

        public final void setIntervalWindowInSeconds(Long intervalWindowInSeconds) {
            this.intervalWindowInSeconds = intervalWindowInSeconds;
        }

        @Override
        @Transient
        public final Builder intervalWindowInSeconds(Long intervalWindowInSeconds) {
            this.intervalWindowInSeconds = intervalWindowInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInterpolatedAssetPropertyValuesRequest build() {
            return new GetInterpolatedAssetPropertyValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInterpolatedAssetPropertyValuesRequest> {
        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder startTimeInSeconds(Long var1);

        public Builder startTimeOffsetInNanos(Integer var1);

        public Builder endTimeInSeconds(Long var1);

        public Builder endTimeOffsetInNanos(Integer var1);

        public Builder quality(String var1);

        public Builder quality(Quality var1);

        public Builder intervalInSeconds(Long var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder type(String var1);

        public Builder intervalWindowInSeconds(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

