/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage;
import software.amazon.awssdk.services.iotsitewise.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutStorageConfigurationRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, PutStorageConfigurationRequest> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(PutStorageConfigurationRequest.getter(PutStorageConfigurationRequest::storageTypeAsString)).setter(PutStorageConfigurationRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("multiLayerStorage").getter(PutStorageConfigurationRequest.getter(PutStorageConfigurationRequest::multiLayerStorage)).setter(PutStorageConfigurationRequest.setter(Builder::multiLayerStorage)).constructor(MultiLayerStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, MULTI_LAYER_STORAGE_FIELD));
    private final String storageType;
    private final MultiLayerStorage multiLayerStorage;

    private PutStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final MultiLayerStorage multiLayerStorage() {
        return this.multiLayerStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiLayerStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageConfigurationRequest)) {
            return false;
        }
        PutStorageConfigurationRequest other = (PutStorageConfigurationRequest)((Object)obj);
        return Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.multiLayerStorage(), other.multiLayerStorage());
    }

    public final String toString() {
        return ToString.builder((String)"PutStorageConfigurationRequest").add("StorageType", (Object)this.storageTypeAsString()).add("MultiLayerStorage", (Object)this.multiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "multiLayerStorage": {
                return Optional.ofNullable(clazz.cast(this.multiLayerStorage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStorageConfigurationRequest, T> g) {
        return obj -> g.apply((PutStorageConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String storageType;
        private MultiLayerStorage multiLayerStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageConfigurationRequest model) {
            super(model);
            this.storageType(model.storageType);
            this.multiLayerStorage(model.multiLayerStorage);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        @Transient
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return this.multiLayerStorage != null ? this.multiLayerStorage.toBuilder() : null;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        @Override
        @Transient
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStorageConfigurationRequest build() {
            return new PutStorageConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutStorageConfigurationRequest> {
        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder multiLayerStorage(MultiLayerStorage var1);

        default public Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return this.multiLayerStorage((MultiLayerStorage)((MultiLayerStorage.Builder)MultiLayerStorage.builder().applyMutation(multiLayerStorage)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

