/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage;
import software.amazon.awssdk.services.iotsitewise.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageConfigurationResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeStorageConfigurationResponse> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::storageTypeAsString)).setter(DescribeStorageConfigurationResponse.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("multiLayerStorage").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::multiLayerStorage)).setter(DescribeStorageConfigurationResponse.setter(Builder::multiLayerStorage)).constructor(MultiLayerStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()}).build();
    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationStatus").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::configurationStatus)).setter(DescribeStorageConfigurationResponse.setter(Builder::configurationStatus)).constructor(ConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateDate").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::lastUpdateDate)).setter(DescribeStorageConfigurationResponse.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, MULTI_LAYER_STORAGE_FIELD, CONFIGURATION_STATUS_FIELD, LAST_UPDATE_DATE_FIELD));
    private final String storageType;
    private final MultiLayerStorage multiLayerStorage;
    private final ConfigurationStatus configurationStatus;
    private final Instant lastUpdateDate;

    private DescribeStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
        this.configurationStatus = builder.configurationStatus;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final MultiLayerStorage multiLayerStorage() {
        return this.multiLayerStorage;
    }

    public final ConfigurationStatus configurationStatus() {
        return this.configurationStatus;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiLayerStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageConfigurationResponse)) {
            return false;
        }
        DescribeStorageConfigurationResponse other = (DescribeStorageConfigurationResponse)((Object)obj);
        return Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.multiLayerStorage(), other.multiLayerStorage()) && Objects.equals(this.configurationStatus(), other.configurationStatus()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageConfigurationResponse").add("StorageType", (Object)this.storageTypeAsString()).add("MultiLayerStorage", (Object)this.multiLayerStorage()).add("ConfigurationStatus", (Object)this.configurationStatus()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "multiLayerStorage": {
                return Optional.ofNullable(clazz.cast(this.multiLayerStorage()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatus()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeStorageConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String storageType;
        private MultiLayerStorage multiLayerStorage;
        private ConfigurationStatus configurationStatus;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageConfigurationResponse model) {
            super(model);
            this.storageType(model.storageType);
            this.multiLayerStorage(model.multiLayerStorage);
            this.configurationStatus(model.configurationStatus);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return this.multiLayerStorage != null ? this.multiLayerStorage.toBuilder() : null;
        }

        @Override
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return this.configurationStatus != null ? this.configurationStatus.toBuilder() : null;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public DescribeStorageConfigurationResponse build() {
            return new DescribeStorageConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageConfigurationResponse> {
        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder multiLayerStorage(MultiLayerStorage var1);

        default public Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return this.multiLayerStorage((MultiLayerStorage)((MultiLayerStorage.Builder)MultiLayerStorage.builder().applyMutation(multiLayerStorage)).build());
        }

        public Builder configurationStatus(ConfigurationStatus var1);

        default public Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return this.configurationStatus((ConfigurationStatus)((ConfigurationStatus.Builder)ConfigurationStatus.builder().applyMutation(configurationStatus)).build());
        }

        public Builder lastUpdateDate(Instant var1);
    }
}

