/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Aggregates;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedValue> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(AggregatedValue.getter(AggregatedValue::timestamp)).setter(AggregatedValue.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quality").getter(AggregatedValue.getter(AggregatedValue::qualityAsString)).setter(AggregatedValue.setter(Builder::quality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()}).build();
    private static final SdkField<Aggregates> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(AggregatedValue.getter(AggregatedValue::value)).setter(AggregatedValue.setter(Builder::value)).constructor(Aggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, QUALITY_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String quality;
    private final Aggregates value;

    private AggregatedValue(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
        this.value = builder.value;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Quality quality() {
        return Quality.fromValue(this.quality);
    }

    public final String qualityAsString() {
        return this.quality;
    }

    public final Aggregates value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedValue)) {
            return false;
        }
        AggregatedValue other = (AggregatedValue)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.qualityAsString(), other.qualityAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatedValue").add("Timestamp", (Object)this.timestamp()).add("Quality", (Object)this.qualityAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "quality": {
                return Optional.ofNullable(clazz.cast(this.qualityAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedValue, T> g) {
        return obj -> g.apply((AggregatedValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String quality;
        private Aggregates value;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedValue model) {
            this.timestamp(model.timestamp);
            this.quality(model.quality);
            this.value(model.value);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getQuality() {
            return this.quality;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        @Override
        @Transient
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        @Transient
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final Aggregates.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(Aggregates.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        @Transient
        public final Builder value(Aggregates value) {
            this.value = value;
            return this;
        }

        public AggregatedValue build() {
            return new AggregatedValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedValue> {
        public Builder timestamp(Instant var1);

        public Builder quality(String var1);

        public Builder quality(Quality var1);

        public Builder value(Aggregates var1);

        default public Builder value(Consumer<Aggregates.Builder> value) {
            return this.value((Aggregates)((Aggregates.Builder)Aggregates.builder().applyMutation(value)).build());
        }
    }
}

