/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus;
import software.amazon.awssdk.services.iotsitewise.model.EncryptionType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDefaultEncryptionConfigurationResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeDefaultEncryptionConfigurationResponse> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionType").getter(DescribeDefaultEncryptionConfigurationResponse.getter(DescribeDefaultEncryptionConfigurationResponse::encryptionTypeAsString)).setter(DescribeDefaultEncryptionConfigurationResponse.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(DescribeDefaultEncryptionConfigurationResponse.getter(DescribeDefaultEncryptionConfigurationResponse::kmsKeyArn)).setter(DescribeDefaultEncryptionConfigurationResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationStatus").getter(DescribeDefaultEncryptionConfigurationResponse.getter(DescribeDefaultEncryptionConfigurationResponse::configurationStatus)).setter(DescribeDefaultEncryptionConfigurationResponse.setter(Builder::configurationStatus)).constructor(ConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD, KMS_KEY_ARN_FIELD, CONFIGURATION_STATUS_FIELD));
    private final String encryptionType;
    private final String kmsKeyArn;
    private final ConfigurationStatus configurationStatus;

    private DescribeDefaultEncryptionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.configurationStatus = builder.configurationStatus;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final ConfigurationStatus configurationStatus() {
        return this.configurationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDefaultEncryptionConfigurationResponse)) {
            return false;
        }
        DescribeDefaultEncryptionConfigurationResponse other = (DescribeDefaultEncryptionConfigurationResponse)((Object)obj);
        return Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.configurationStatus(), other.configurationStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDefaultEncryptionConfigurationResponse").add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("ConfigurationStatus", (Object)this.configurationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDefaultEncryptionConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDefaultEncryptionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String encryptionType;
        private String kmsKeyArn;
        private ConfigurationStatus configurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDefaultEncryptionConfigurationResponse model) {
            super(model);
            this.encryptionType(model.encryptionType);
            this.kmsKeyArn(model.kmsKeyArn);
            this.configurationStatus(model.configurationStatus);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        @Transient
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return this.configurationStatus != null ? this.configurationStatus.toBuilder() : null;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public DescribeDefaultEncryptionConfigurationResponse build() {
            return new DescribeDefaultEncryptionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDefaultEncryptionConfigurationResponse> {
        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder kmsKeyArn(String var1);

        public Builder configurationStatus(ConfigurationStatus var1);

        default public Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return this.configurationStatus((ConfigurationStatus)((ConfigurationStatus.Builder)ConfigurationStatus.builder().applyMutation(configurationStatus)).build());
        }
    }
}

