/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TraversalType {
    PATH_TO_ROOT("PATH_TO_ROOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TraversalType> VALUE_MAP;
    private final String value;

    private TraversalType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TraversalType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TraversalType> knownValues() {
        EnumSet<TraversalType> knownValues = EnumSet.allOf(TraversalType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TraversalType.class, TraversalType::toString);
    }
}

