/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;

public class BatchGetAssetPropertyValueHistoryPublisher
implements SdkPublisher<BatchGetAssetPropertyValueHistoryResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final BatchGetAssetPropertyValueHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetAssetPropertyValueHistoryPublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyValueHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetAssetPropertyValueHistoryPublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyValueHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetAssetPropertyValueHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetAssetPropertyValueHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class BatchGetAssetPropertyValueHistoryResponseFetcher
    implements AsyncPageFetcher<BatchGetAssetPropertyValueHistoryResponse> {
        private BatchGetAssetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> nextPage(BatchGetAssetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyValueHistoryPublisher.this.client.batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryPublisher.this.firstRequest);
            }
            return BatchGetAssetPropertyValueHistoryPublisher.this.client.batchGetAssetPropertyValueHistory((BatchGetAssetPropertyValueHistoryRequest)((Object)BatchGetAssetPropertyValueHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

