/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;

public class ListAssetRelationshipsIterable
implements SdkIterable<ListAssetRelationshipsResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetRelationshipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetRelationshipsIterable(IoTSiteWiseClient client, ListAssetRelationshipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssetRelationshipsResponseFetcher();
    }

    public Iterator<ListAssetRelationshipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetRelationshipSummary> assetRelationshipSummaries() {
        Function<ListAssetRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetRelationshipSummaries() != null) {
                return response.assetRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetRelationshipsResponseFetcher
    implements SyncPageFetcher<ListAssetRelationshipsResponse> {
        private ListAssetRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetRelationshipsResponse nextPage(ListAssetRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetRelationshipsIterable.this.client.listAssetRelationships(ListAssetRelationshipsIterable.this.firstRequest);
            }
            return ListAssetRelationshipsIterable.this.client.listAssetRelationships((ListAssetRelationshipsRequest)((Object)ListAssetRelationshipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

