/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetCompositeModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetCompositeModel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetCompositeModel.getter(AssetCompositeModel::name)).setter(AssetCompositeModel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssetCompositeModel.getter(AssetCompositeModel::description)).setter(AssetCompositeModel.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AssetCompositeModel.getter(AssetCompositeModel::type)).setter(AssetCompositeModel.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<AssetProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("properties").getter(AssetCompositeModel.getter(AssetCompositeModel::properties)).setter(AssetCompositeModel.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String type;
    private final List<AssetProperty> properties;

    private AssetCompositeModel(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.properties = builder.properties;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<AssetProperty> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetCompositeModel)) {
            return false;
        }
        AssetCompositeModel other = (AssetCompositeModel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"AssetCompositeModel").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetCompositeModel, T> g) {
        return obj -> g.apply((AssetCompositeModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String type;
        private List<AssetProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetCompositeModel model) {
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.properties(model.properties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<AssetProperty.Builder> getProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<AssetProperty.BuilderImpl> properties) {
            this.properties = AssetPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        @Transient
        public final Builder properties(Collection<AssetProperty> properties) {
            this.properties = AssetPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(AssetProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(Consumer<AssetProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (AssetProperty)((AssetProperty.Builder)AssetProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetCompositeModel build() {
            return new AssetCompositeModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetCompositeModel> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder properties(Collection<AssetProperty> var1);

        public Builder properties(AssetProperty ... var1);

        public Builder properties(Consumer<AssetProperty.Builder> ... var1);
    }
}

