/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Identity;
import software.amazon.awssdk.services.iotsitewise.model.Permission;
import software.amazon.awssdk.services.iotsitewise.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPolicySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AccessPolicySummary.getter(AccessPolicySummary::id)).setter(AccessPolicySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identity").getter(AccessPolicySummary.getter(AccessPolicySummary::identity)).setter(AccessPolicySummary.setter(Builder::identity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(AccessPolicySummary.getter(AccessPolicySummary::resource)).setter(AccessPolicySummary.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permission").getter(AccessPolicySummary.getter(AccessPolicySummary::permissionAsString)).setter(AccessPolicySummary.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(AccessPolicySummary.getter(AccessPolicySummary::creationDate)).setter(AccessPolicySummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateDate").getter(AccessPolicySummary.getter(AccessPolicySummary::lastUpdateDate)).setter(AccessPolicySummary.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IDENTITY_FIELD, RESOURCE_FIELD, PERMISSION_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Identity identity;
    private final Resource resource;
    private final String permission;
    private final Instant creationDate;
    private final Instant lastUpdateDate;

    private AccessPolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.identity = builder.identity;
        this.resource = builder.resource;
        this.permission = builder.permission;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public final String id() {
        return this.id;
    }

    public final Identity identity() {
        return this.identity;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPolicySummary)) {
            return false;
        }
        AccessPolicySummary other = (AccessPolicySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPolicySummary").add("Id", (Object)this.id()).add("Identity", (Object)this.identity()).add("Resource", (Object)this.resource()).add("Permission", (Object)this.permissionAsString()).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPolicySummary, T> g) {
        return obj -> g.apply((AccessPolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Identity identity;
        private Resource resource;
        private String permission;
        private Instant creationDate;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPolicySummary model) {
            this.id(model.id);
            this.identity(model.identity);
            this.resource(model.resource);
            this.permission(model.permission);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Identity.Builder getIdentity() {
            return this.identity != null ? this.identity.toBuilder() : null;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        @Override
        @Transient
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        @Transient
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        @Transient
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        @Transient
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        @Transient
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public AccessPolicySummary build() {
            return new AccessPolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPolicySummary> {
        public Builder id(String var1);

        public Builder identity(Identity var1);

        default public Builder identity(Consumer<Identity.Builder> identity) {
            return this.identity((Identity)((Identity.Builder)Identity.builder().applyMutation(identity)).build());
        }

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

