/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.PortalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePortalResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreatePortalResponse> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalId").getter(CreatePortalResponse.getter(CreatePortalResponse::portalId)).setter(CreatePortalResponse.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(CreatePortalResponse.getter(CreatePortalResponse::portalArn)).setter(CreatePortalResponse.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<String> PORTAL_START_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalStartUrl").getter(CreatePortalResponse.getter(CreatePortalResponse::portalStartUrl)).setter(CreatePortalResponse.setter(Builder::portalStartUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStartUrl").build()}).build();
    private static final SdkField<PortalStatus> PORTAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portalStatus").getter(CreatePortalResponse.getter(CreatePortalResponse::portalStatus)).setter(CreatePortalResponse.setter(Builder::portalStatus)).constructor(PortalStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()}).build();
    private static final SdkField<String> SSO_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssoApplicationId").getter(CreatePortalResponse.getter(CreatePortalResponse::ssoApplicationId)).setter(CreatePortalResponse.setter(Builder::ssoApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoApplicationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD, PORTAL_ARN_FIELD, PORTAL_START_URL_FIELD, PORTAL_STATUS_FIELD, SSO_APPLICATION_ID_FIELD));
    private final String portalId;
    private final String portalArn;
    private final String portalStartUrl;
    private final PortalStatus portalStatus;
    private final String ssoApplicationId;

    private CreatePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalArn = builder.portalArn;
        this.portalStartUrl = builder.portalStartUrl;
        this.portalStatus = builder.portalStatus;
        this.ssoApplicationId = builder.ssoApplicationId;
    }

    public final String portalId() {
        return this.portalId;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final String portalStartUrl() {
        return this.portalStartUrl;
    }

    public final PortalStatus portalStatus() {
        return this.portalStatus;
    }

    public final String ssoApplicationId() {
        return this.ssoApplicationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalStartUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssoApplicationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalResponse)) {
            return false;
        }
        CreatePortalResponse other = (CreatePortalResponse)((Object)obj);
        return Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.portalStartUrl(), other.portalStartUrl()) && Objects.equals(this.portalStatus(), other.portalStatus()) && Objects.equals(this.ssoApplicationId(), other.ssoApplicationId());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePortalResponse").add("PortalId", (Object)this.portalId()).add("PortalArn", (Object)this.portalArn()).add("PortalStartUrl", (Object)this.portalStartUrl()).add("PortalStatus", (Object)this.portalStatus()).add("SsoApplicationId", (Object)this.ssoApplicationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "portalStartUrl": {
                return Optional.ofNullable(clazz.cast(this.portalStartUrl()));
            }
            case "portalStatus": {
                return Optional.ofNullable(clazz.cast(this.portalStatus()));
            }
            case "ssoApplicationId": {
                return Optional.ofNullable(clazz.cast(this.ssoApplicationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalResponse, T> g) {
        return obj -> g.apply((CreatePortalResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String portalId;
        private String portalArn;
        private String portalStartUrl;
        private PortalStatus portalStatus;
        private String ssoApplicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalResponse model) {
            super(model);
            this.portalId(model.portalId);
            this.portalArn(model.portalArn);
            this.portalStartUrl(model.portalStartUrl);
            this.portalStatus(model.portalStatus);
            this.ssoApplicationId(model.ssoApplicationId);
        }

        public final String getPortalId() {
            return this.portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        @Transient
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        @Transient
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalStartUrl() {
            return this.portalStartUrl;
        }

        public final void setPortalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
        }

        @Override
        @Transient
        public final Builder portalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
            return this;
        }

        public final PortalStatus.Builder getPortalStatus() {
            return this.portalStatus != null ? this.portalStatus.toBuilder() : null;
        }

        public final void setPortalStatus(PortalStatus.BuilderImpl portalStatus) {
            this.portalStatus = portalStatus != null ? portalStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        public final String getSsoApplicationId() {
            return this.ssoApplicationId;
        }

        public final void setSsoApplicationId(String ssoApplicationId) {
            this.ssoApplicationId = ssoApplicationId;
        }

        @Override
        @Transient
        public final Builder ssoApplicationId(String ssoApplicationId) {
            this.ssoApplicationId = ssoApplicationId;
            return this;
        }

        @Override
        public CreatePortalResponse build() {
            return new CreatePortalResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePortalResponse> {
        public Builder portalId(String var1);

        public Builder portalArn(String var1);

        public Builder portalStartUrl(String var1);

        public Builder portalStatus(PortalStatus var1);

        default public Builder portalStatus(Consumer<PortalStatus.Builder> portalStatus) {
            return this.portalStatus((PortalStatus)((PortalStatus.Builder)PortalStatus.builder().applyMutation(portalStatus)).build());
        }

        public Builder ssoApplicationId(String var1);
    }
}

