/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetModelsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListAssetModelsResponse> {
    private static final SdkField<List<AssetModelSummary>> ASSET_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelSummaries").getter(ListAssetModelsResponse.getter(ListAssetModelsResponse::assetModelSummaries)).setter(ListAssetModelsResponse.setter(Builder::assetModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssetModelsResponse.getter(ListAssetModelsResponse::nextToken)).setter(ListAssetModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssetModelSummary> assetModelSummaries;
    private final String nextToken;

    private ListAssetModelsResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelSummaries = builder.assetModelSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssetModelSummaries() {
        return this.assetModelSummaries != null && !(this.assetModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetModelSummary> assetModelSummaries() {
        return this.assetModelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelSummaries() ? this.assetModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetModelsResponse)) {
            return false;
        }
        ListAssetModelsResponse other = (ListAssetModelsResponse)((Object)obj);
        return this.hasAssetModelSummaries() == other.hasAssetModelSummaries() && Objects.equals(this.assetModelSummaries(), other.assetModelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetModelsResponse").add("AssetModelSummaries", this.hasAssetModelSummaries() ? this.assetModelSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.assetModelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetModelsResponse, T> g) {
        return obj -> g.apply((ListAssetModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<AssetModelSummary> assetModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetModelsResponse model) {
            super(model);
            this.assetModelSummaries(model.assetModelSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssetModelSummary.Builder> getAssetModelSummaries() {
            List<AssetModelSummary.Builder> result = AssetModelSummariesCopier.copyToBuilder(this.assetModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder assetModelSummaries(Collection<AssetModelSummary> assetModelSummaries) {
            this.assetModelSummaries = AssetModelSummariesCopier.copy(assetModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelSummaries(AssetModelSummary ... assetModelSummaries) {
            this.assetModelSummaries(Arrays.asList(assetModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelSummaries(Consumer<AssetModelSummary.Builder> ... assetModelSummaries) {
            this.assetModelSummaries(Stream.of(assetModelSummaries).map(c -> (AssetModelSummary)((AssetModelSummary.Builder)AssetModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelSummaries(Collection<AssetModelSummary.BuilderImpl> assetModelSummaries) {
            this.assetModelSummaries = AssetModelSummariesCopier.copyFromBuilder(assetModelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssetModelsResponse build() {
            return new ListAssetModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetModelsResponse> {
        public Builder assetModelSummaries(Collection<AssetModelSummary> var1);

        public Builder assetModelSummaries(AssetModelSummary ... var1);

        public Builder assetModelSummaries(Consumer<AssetModelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

