/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Variant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Variant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(Variant.getter(Variant::stringValue)).setter(Variant.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("integerValue").getter(Variant.getter(Variant::integerValue)).setter(Variant.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(Variant.getter(Variant::doubleValue)).setter(Variant.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(Variant.getter(Variant::booleanValue)).setter(Variant.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final Integer integerValue;
    private final Double doubleValue;
    private final Boolean booleanValue;

    private Variant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant other = (Variant)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.booleanValue(), other.booleanValue());
    }

    public final String toString() {
        return ToString.builder((String)"Variant").add("StringValue", (Object)this.stringValue()).add("IntegerValue", (Object)this.integerValue()).add("DoubleValue", (Object)this.doubleValue()).add("BooleanValue", (Object)this.booleanValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Variant, T> g) {
        return obj -> g.apply((Variant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private Integer integerValue;
        private Double doubleValue;
        private Boolean booleanValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Variant model) {
            this.stringValue(model.stringValue);
            this.integerValue(model.integerValue);
            this.doubleValue(model.doubleValue);
            this.booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public Variant build() {
            return new Variant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Variant> {
        public Builder stringValue(String var1);

        public Builder integerValue(Integer var1);

        public Builder doubleValue(Double var1);

        public Builder booleanValue(Boolean var1);
    }
}

