/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListAssetsRequest.Builder, ListAssetsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssetsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(ListAssetsRequest::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelId").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(ListAssetsRequest::filterAsString)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, ASSET_MODEL_ID_FIELD, FILTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String assetModelId;

    private final String filter;

    private ListAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assetModelId = builder.assetModelId;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned per paginated request.
     * </p>
     * <p>
     * Default: 50
     * </p>
     * 
     * @return The maximum number of results to be returned per paginated request.</p>
     *         <p>
     *         Default: 50
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ID of the asset model by which to filter the list of assets. This parameter is required if you choose
     * <code>ALL</code> for <code>filter</code>.
     * </p>
     * 
     * @return The ID of the asset model by which to filter the list of assets. This parameter is required if you choose
     *         <code>ALL</code> for <code>filter</code>.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The filter for the requested list of assets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
     * parameter is required if you filter by <code>ALL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>ALL</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link ListAssetsFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return The filter for the requested list of assets. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
     *         parameter is required if you filter by <code>ALL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>ALL</code>
     * @see ListAssetsFilter
     */
    public final ListAssetsFilter filter() {
        return ListAssetsFilter.fromValue(filter);
    }

    /**
     * <p>
     * The filter for the requested list of assets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
     * parameter is required if you filter by <code>ALL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>ALL</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link ListAssetsFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return The filter for the requested list of assets. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
     *         parameter is required if you filter by <code>ALL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>ALL</code>
     * @see ListAssetsFilter
     */
    public final String filterAsString() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(filterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsRequest)) {
            return false;
        }
        ListAssetsRequest other = (ListAssetsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(filterAsString(), other.filterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AssetModelId", assetModelId()).add("Filter", filterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsRequest, T> g) {
        return obj -> g.apply((ListAssetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssetsRequest> {
        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned per paginated request.
         * </p>
         * <p>
         * Default: 50
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per paginated request.</p>
         *        <p>
         *        Default: 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ID of the asset model by which to filter the list of assets. This parameter is required if you choose
         * <code>ALL</code> for <code>filter</code>.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model by which to filter the list of assets. This parameter is required if you
         *        choose <code>ALL</code> for <code>filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The filter for the requested list of assets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
         * parameter is required if you filter by <code>ALL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>ALL</code>
         * </p>
         * 
         * @param filter
         *        The filter for the requested list of assets. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all assets for a given asset model ID. The
         *        <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>ALL</code>
         * @see ListAssetsFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListAssetsFilter
         */
        Builder filter(String filter);

        /**
         * <p>
         * The filter for the requested list of assets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code>
         * parameter is required if you filter by <code>ALL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>ALL</code>
         * </p>
         * 
         * @param filter
         *        The filter for the requested list of assets. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code> – The list includes all assets for a given asset model ID. The
         *        <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>ALL</code>
         * @see ListAssetsFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListAssetsFilter
         */
        Builder filter(ListAssetsFilter filter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String assetModelId;

        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            assetModelId(model.assetModelId);
            filter(model.filter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final String getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder filter(ListAssetsFilter filter) {
            this.filter(filter == null ? null : filter.toString());
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetsRequest build() {
            return new ListAssetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
