/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPoliciesResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListAccessPoliciesResponse.Builder, ListAccessPoliciesResponse> {
    private static final SdkField<List<AccessPolicySummary>> ACCESS_POLICY_SUMMARIES_FIELD = SdkField
            .<List<AccessPolicySummary>> builder(MarshallingType.LIST)
            .memberName("accessPolicySummaries")
            .getter(getter(ListAccessPoliciesResponse::accessPolicySummaries))
            .setter(setter(Builder::accessPolicySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccessPolicySummary> accessPolicySummaries;

    private final String nextToken;

    private ListAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicySummaries = builder.accessPolicySummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccessPolicySummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAccessPolicySummaries() {
        return accessPolicySummaries != null && !(accessPolicySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each access policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessPolicySummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each access policy.
     */
    public final List<AccessPolicySummary> accessPolicySummaries() {
        return accessPolicySummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPolicySummaries() ? accessPolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPoliciesResponse)) {
            return false;
        }
        ListAccessPoliciesResponse other = (ListAccessPoliciesResponse) obj;
        return hasAccessPolicySummaries() == other.hasAccessPolicySummaries()
                && Objects.equals(accessPolicySummaries(), other.accessPolicySummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPoliciesResponse")
                .add("AccessPolicySummaries", hasAccessPolicySummaries() ? accessPolicySummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicySummaries":
            return Optional.ofNullable(clazz.cast(accessPolicySummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPoliciesResponse, T> g) {
        return obj -> g.apply((ListAccessPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessPoliciesResponse> {
        /**
         * <p>
         * A list that summarizes each access policy.
         * </p>
         * 
         * @param accessPolicySummaries
         *        A list that summarizes each access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicySummaries(Collection<AccessPolicySummary> accessPolicySummaries);

        /**
         * <p>
         * A list that summarizes each access policy.
         * </p>
         * 
         * @param accessPolicySummaries
         *        A list that summarizes each access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicySummaries(AccessPolicySummary... accessPolicySummaries);

        /**
         * <p>
         * A list that summarizes each access policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessPolicySummary>.Builder} avoiding the
         * need to create one manually via {@link List<AccessPolicySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessPolicySummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #accessPolicySummaries(List<AccessPolicySummary>)}.
         * 
         * @param accessPolicySummaries
         *        a consumer that will call methods on {@link List<AccessPolicySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicySummaries(List<AccessPolicySummary>)
         */
        Builder accessPolicySummaries(Consumer<AccessPolicySummary.Builder>... accessPolicySummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<AccessPolicySummary> accessPolicySummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPoliciesResponse model) {
            super(model);
            accessPolicySummaries(model.accessPolicySummaries);
            nextToken(model.nextToken);
        }

        public final Collection<AccessPolicySummary.Builder> getAccessPolicySummaries() {
            if (accessPolicySummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return accessPolicySummaries != null ? accessPolicySummaries.stream().map(AccessPolicySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessPolicySummaries(Collection<AccessPolicySummary> accessPolicySummaries) {
            this.accessPolicySummaries = AccessPolicySummariesCopier.copy(accessPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicySummaries(AccessPolicySummary... accessPolicySummaries) {
            accessPolicySummaries(Arrays.asList(accessPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicySummaries(Consumer<AccessPolicySummary.Builder>... accessPolicySummaries) {
            accessPolicySummaries(Stream.of(accessPolicySummaries)
                    .map(c -> AccessPolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPolicySummaries(Collection<AccessPolicySummary.BuilderImpl> accessPolicySummaries) {
            this.accessPolicySummaries = AccessPolicySummariesCopier.copyFromBuilder(accessPolicySummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccessPoliciesResponse build() {
            return new ListAccessPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
