/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewaySummary implements SdkPojo, Serializable, ToCopyableBuilder<GatewaySummary.Builder, GatewaySummary> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(GatewaySummary::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayName").getter(getter(GatewaySummary::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayName").build()).build();

    private static final SdkField<List<GatewayCapabilitySummary>> GATEWAY_CAPABILITY_SUMMARIES_FIELD = SdkField
            .<List<GatewayCapabilitySummary>> builder(MarshallingType.LIST)
            .memberName("gatewayCapabilitySummaries")
            .getter(getter(GatewaySummary::gatewayCapabilitySummaries))
            .setter(setter(Builder::gatewayCapabilitySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayCapabilitySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayCapabilitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayCapabilitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(GatewaySummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(GatewaySummary::lastUpdateDate)).setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            GATEWAY_NAME_FIELD, GATEWAY_CAPABILITY_SUMMARIES_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gatewayId;

    private final String gatewayName;

    private final List<GatewayCapabilitySummary> gatewayCapabilitySummaries;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private GatewaySummary(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayCapabilitySummaries = builder.gatewayCapabilitySummaries;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    /**
     * <p>
     * The ID of the gateway device.
     * </p>
     * 
     * @return The ID of the gateway device.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * Returns true if the GatewayCapabilitySummaries property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasGatewayCapabilitySummaries() {
        return gatewayCapabilitySummaries != null && !(gatewayCapabilitySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines
     * data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
     * >DescribeGatewayCapabilityConfiguration</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGatewayCapabilitySummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
     *         defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
     *         "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
     *         >DescribeGatewayCapabilityConfiguration</a>.
     */
    public final List<GatewayCapabilitySummary> gatewayCapabilitySummaries() {
        return gatewayCapabilitySummaries;
    }

    /**
     * <p>
     * The date the gateway was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the gateway was created, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the gateway was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the gateway was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayCapabilitySummaries() ? gatewayCapabilitySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewaySummary)) {
            return false;
        }
        GatewaySummary other = (GatewaySummary) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(gatewayName(), other.gatewayName())
                && hasGatewayCapabilitySummaries() == other.hasGatewayCapabilitySummaries()
                && Objects.equals(gatewayCapabilitySummaries(), other.gatewayCapabilitySummaries())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewaySummary").add("GatewayId", gatewayId()).add("GatewayName", gatewayName())
                .add("GatewayCapabilitySummaries", hasGatewayCapabilitySummaries() ? gatewayCapabilitySummaries() : null)
                .add("CreationDate", creationDate()).add("LastUpdateDate", lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "gatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "gatewayCapabilitySummaries":
            return Optional.ofNullable(clazz.cast(gatewayCapabilitySummaries()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewaySummary, T> g) {
        return obj -> g.apply((GatewaySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewaySummary> {
        /**
         * <p>
         * The ID of the gateway device.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param gatewayName
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * 
         * @param gatewayCapabilitySummaries
         *        A list of gateway capability summaries that each contain a namespace and status. Each gateway
         *        capability defines data sources for the gateway. To retrieve a capability configuration's definition,
         *        use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         *        >DescribeGatewayCapabilityConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries);

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * 
         * @param gatewayCapabilitySummaries
         *        A list of gateway capability summaries that each contain a namespace and status. Each gateway
         *        capability defines data sources for the gateway. To retrieve a capability configuration's definition,
         *        use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         *        >DescribeGatewayCapabilityConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayCapabilitySummaries(GatewayCapabilitySummary... gatewayCapabilitySummaries);

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GatewayCapabilitySummary>.Builder} avoiding
         * the need to create one manually via {@link List<GatewayCapabilitySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewayCapabilitySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #gatewayCapabilitySummaries(List<GatewayCapabilitySummary>)}.
         * 
         * @param gatewayCapabilitySummaries
         *        a consumer that will call methods on {@link List<GatewayCapabilitySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayCapabilitySummaries(List<GatewayCapabilitySummary>)
         */
        Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder>... gatewayCapabilitySummaries);

        /**
         * <p>
         * The date the gateway was created, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The date the gateway was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the gateway was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the gateway was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private String gatewayName;

        private List<GatewayCapabilitySummary> gatewayCapabilitySummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewaySummary model) {
            gatewayId(model.gatewayId);
            gatewayName(model.gatewayName);
            gatewayCapabilitySummaries(model.gatewayCapabilitySummaries);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final Collection<GatewayCapabilitySummary.Builder> getGatewayCapabilitySummaries() {
            if (gatewayCapabilitySummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayCapabilitySummaries != null ? gatewayCapabilitySummaries.stream()
                    .map(GatewayCapabilitySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copy(gatewayCapabilitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(GatewayCapabilitySummary... gatewayCapabilitySummaries) {
            gatewayCapabilitySummaries(Arrays.asList(gatewayCapabilitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder>... gatewayCapabilitySummaries) {
            gatewayCapabilitySummaries(Stream.of(gatewayCapabilitySummaries)
                    .map(c -> GatewayCapabilitySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayCapabilitySummaries(
                Collection<GatewayCapabilitySummary.BuilderImpl> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copyFromBuilder(gatewayCapabilitySummaries);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public GatewaySummary build() {
            return new GatewaySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
