/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePortalRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DeletePortalRequest.Builder, DeletePortalRequest> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(DeletePortalRequest::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeletePortalRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String portalId;

    private final String clientToken;

    private DeletePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the portal to delete.
     * </p>
     * 
     * @return The ID of the portal to delete.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePortalRequest)) {
            return false;
        }
        DeletePortalRequest other = (DeletePortalRequest) obj;
        return Objects.equals(portalId(), other.portalId()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePortalRequest").add("PortalId", portalId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePortalRequest, T> g) {
        return obj -> g.apply((DeletePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePortalRequest> {
        /**
         * <p>
         * The ID of the portal to delete.
         * </p>
         * 
         * @param portalId
         *        The ID of the portal to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String portalId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePortalRequest model) {
            super(model);
            portalId(model.portalId);
            clientToken(model.clientToken);
        }

        public final String getPortalId() {
            return portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePortalRequest build() {
            return new DeletePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
