/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains asset property value information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertyValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertyValue.Builder, AssetPropertyValue> {
    private static final SdkField<Variant> VALUE_FIELD = SdkField.<Variant> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(AssetPropertyValue::value)).setter(setter(Builder::value)).constructor(Variant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<TimeInNanos> TIMESTAMP_FIELD = SdkField.<TimeInNanos> builder(MarshallingType.SDK_POJO)
            .memberName("timestamp").getter(getter(AssetPropertyValue::timestamp)).setter(setter(Builder::timestamp))
            .constructor(TimeInNanos::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("quality")
            .getter(getter(AssetPropertyValue::qualityAsString)).setter(setter(Builder::quality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD,
            QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Variant value;

    private final TimeInNanos timestamp;

    private final String quality;

    private AssetPropertyValue(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
    }

    /**
     * <p>
     * The value of the asset property (see <code>Variant</code>).
     * </p>
     * 
     * @return The value of the asset property (see <code>Variant</code>).
     */
    public final Variant value() {
        return value;
    }

    /**
     * <p>
     * The timestamp of the asset property value.
     * </p>
     * 
     * @return The timestamp of the asset property value.
     */
    public final TimeInNanos timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The quality of the asset property value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the asset property value.
     * @see Quality
     */
    public final Quality quality() {
        return Quality.fromValue(quality);
    }

    /**
     * <p>
     * The quality of the asset property value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the asset property value.
     * @see Quality
     */
    public final String qualityAsString() {
        return quality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(qualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyValue)) {
            return false;
        }
        AssetPropertyValue other = (AssetPropertyValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(qualityAsString(), other.qualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertyValue").add("Value", value()).add("Timestamp", timestamp())
                .add("Quality", qualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "quality":
            return Optional.ofNullable(clazz.cast(qualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyValue, T> g) {
        return obj -> g.apply((AssetPropertyValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertyValue> {
        /**
         * <p>
         * The value of the asset property (see <code>Variant</code>).
         * </p>
         * 
         * @param value
         *        The value of the asset property (see <code>Variant</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Variant value);

        /**
         * <p>
         * The value of the asset property (see <code>Variant</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link Variant.Builder} avoiding the need to create one
         * manually via {@link Variant#builder()}.
         *
         * When the {@link Consumer} completes, {@link Variant.Builder#build()} is called immediately and its result is
         * passed to {@link #value(Variant)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Variant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Variant)
         */
        default Builder value(Consumer<Variant.Builder> value) {
            return value(Variant.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The timestamp of the asset property value.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the asset property value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(TimeInNanos timestamp);

        /**
         * <p>
         * The timestamp of the asset property value.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeInNanos.Builder} avoiding the need to create
         * one manually via {@link TimeInNanos#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeInNanos.Builder#build()} is called immediately and its result
         * is passed to {@link #timestamp(TimeInNanos)}.
         * 
         * @param timestamp
         *        a consumer that will call methods on {@link TimeInNanos.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestamp(TimeInNanos)
         */
        default Builder timestamp(Consumer<TimeInNanos.Builder> timestamp) {
            return timestamp(TimeInNanos.builder().applyMutation(timestamp).build());
        }

        /**
         * <p>
         * The quality of the asset property value.
         * </p>
         * 
         * @param quality
         *        The quality of the asset property value.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(String quality);

        /**
         * <p>
         * The quality of the asset property value.
         * </p>
         * 
         * @param quality
         *        The quality of the asset property value.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(Quality quality);
    }

    static final class BuilderImpl implements Builder {
        private Variant value;

        private TimeInNanos timestamp;

        private String quality;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyValue model) {
            value(model.value);
            timestamp(model.timestamp);
            quality(model.quality);
        }

        public final Variant.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        @Override
        public final Builder value(Variant value) {
            this.value = value;
            return this;
        }

        public final void setValue(Variant.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final TimeInNanos.Builder getTimestamp() {
            return timestamp != null ? timestamp.toBuilder() : null;
        }

        @Override
        public final Builder timestamp(TimeInNanos timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(TimeInNanos.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        public final String getQuality() {
            return quality;
        }

        @Override
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        @Override
        public AssetPropertyValue build() {
            return new AssetPropertyValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
