/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a parent asset and a child asset that are related through an asset hierarchy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetHierarchyInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetHierarchyInfo.Builder, AssetHierarchyInfo> {
    private static final SdkField<String> PARENT_ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentAssetId").getter(getter(AssetHierarchyInfo::parentAssetId)).setter(setter(Builder::parentAssetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentAssetId").build()).build();

    private static final SdkField<String> CHILD_ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childAssetId").getter(getter(AssetHierarchyInfo::childAssetId)).setter(setter(Builder::childAssetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childAssetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ASSET_ID_FIELD,
            CHILD_ASSET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parentAssetId;

    private final String childAssetId;

    private AssetHierarchyInfo(BuilderImpl builder) {
        this.parentAssetId = builder.parentAssetId;
        this.childAssetId = builder.childAssetId;
    }

    /**
     * <p>
     * The ID of the parent asset in this asset relationship.
     * </p>
     * 
     * @return The ID of the parent asset in this asset relationship.
     */
    public final String parentAssetId() {
        return parentAssetId;
    }

    /**
     * <p>
     * The ID of the child asset in this asset relationship.
     * </p>
     * 
     * @return The ID of the child asset in this asset relationship.
     */
    public final String childAssetId() {
        return childAssetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(childAssetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetHierarchyInfo)) {
            return false;
        }
        AssetHierarchyInfo other = (AssetHierarchyInfo) obj;
        return Objects.equals(parentAssetId(), other.parentAssetId()) && Objects.equals(childAssetId(), other.childAssetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetHierarchyInfo").add("ParentAssetId", parentAssetId()).add("ChildAssetId", childAssetId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentAssetId":
            return Optional.ofNullable(clazz.cast(parentAssetId()));
        case "childAssetId":
            return Optional.ofNullable(clazz.cast(childAssetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetHierarchyInfo, T> g) {
        return obj -> g.apply((AssetHierarchyInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetHierarchyInfo> {
        /**
         * <p>
         * The ID of the parent asset in this asset relationship.
         * </p>
         * 
         * @param parentAssetId
         *        The ID of the parent asset in this asset relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentAssetId(String parentAssetId);

        /**
         * <p>
         * The ID of the child asset in this asset relationship.
         * </p>
         * 
         * @param childAssetId
         *        The ID of the child asset in this asset relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childAssetId(String childAssetId);
    }

    static final class BuilderImpl implements Builder {
        private String parentAssetId;

        private String childAssetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetHierarchyInfo model) {
            parentAssetId(model.parentAssetId);
            childAssetId(model.childAssetId);
        }

        public final String getParentAssetId() {
            return parentAssetId;
        }

        @Override
        public final Builder parentAssetId(String parentAssetId) {
            this.parentAssetId = parentAssetId;
            return this;
        }

        public final void setParentAssetId(String parentAssetId) {
            this.parentAssetId = parentAssetId;
        }

        public final String getChildAssetId() {
            return childAssetId;
        }

        @Override
        public final Builder childAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
            return this;
        }

        public final void setChildAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
        }

        @Override
        public AssetHierarchyInfo build() {
            return new AssetHierarchyInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
