/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresignedPortalUrlRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreatePresignedPortalUrlRequest> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalId").getter(CreatePresignedPortalUrlRequest.getter(CreatePresignedPortalUrlRequest::portalId)).setter(CreatePresignedPortalUrlRequest.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalId").build()}).build();
    private static final SdkField<Integer> SESSION_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionDurationSeconds").getter(CreatePresignedPortalUrlRequest.getter(CreatePresignedPortalUrlRequest::sessionDurationSeconds)).setter(CreatePresignedPortalUrlRequest.setter(Builder::sessionDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionDurationSeconds").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CreatePresignedPortalUrlRequest.getter(CreatePresignedPortalUrlRequest::state)).setter(CreatePresignedPortalUrlRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD, SESSION_DURATION_SECONDS_FIELD, STATE_FIELD));
    private final String portalId;
    private final Integer sessionDurationSeconds;
    private final String state;

    private CreatePresignedPortalUrlRequest(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.sessionDurationSeconds = builder.sessionDurationSeconds;
        this.state = builder.state;
    }

    public final String portalId() {
        return this.portalId;
    }

    public final Integer sessionDurationSeconds() {
        return this.sessionDurationSeconds;
    }

    public final String state() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedPortalUrlRequest)) {
            return false;
        }
        CreatePresignedPortalUrlRequest other = (CreatePresignedPortalUrlRequest)((Object)obj);
        return Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.sessionDurationSeconds(), other.sessionDurationSeconds()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresignedPortalUrlRequest").add("PortalId", (Object)this.portalId()).add("SessionDurationSeconds", (Object)this.sessionDurationSeconds()).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "sessionDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionDurationSeconds()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedPortalUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedPortalUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String portalId;
        private Integer sessionDurationSeconds;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedPortalUrlRequest model) {
            super(model);
            this.portalId(model.portalId);
            this.sessionDurationSeconds(model.sessionDurationSeconds);
            this.state(model.state);
        }

        public final String getPortalId() {
            return this.portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        public final Integer getSessionDurationSeconds() {
            return this.sessionDurationSeconds;
        }

        @Override
        public final Builder sessionDurationSeconds(Integer sessionDurationSeconds) {
            this.sessionDurationSeconds = sessionDurationSeconds;
            return this;
        }

        public final void setSessionDurationSeconds(Integer sessionDurationSeconds) {
            this.sessionDurationSeconds = sessionDurationSeconds;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedPortalUrlRequest build() {
            return new CreatePresignedPortalUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresignedPortalUrlRequest> {
        public Builder portalId(String var1);

        public Builder sessionDurationSeconds(Integer var1);

        public Builder state(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

