/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode;
import software.amazon.awssdk.services.iotsitewise.model.TimeInNanos;
import software.amazon.awssdk.services.iotsitewise.model.TimestampsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutAssetPropertyError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchPutAssetPropertyError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(BatchPutAssetPropertyError.getter(BatchPutAssetPropertyError::errorCodeAsString)).setter(BatchPutAssetPropertyError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(BatchPutAssetPropertyError.getter(BatchPutAssetPropertyError::errorMessage)).setter(BatchPutAssetPropertyError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<TimeInNanos>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("timestamps").getter(BatchPutAssetPropertyError.getter(BatchPutAssetPropertyError::timestamps)).setter(BatchPutAssetPropertyError.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeInNanos::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, TIMESTAMPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String errorMessage;
    private final List<TimeInNanos> timestamps;

    private BatchPutAssetPropertyError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.timestamps = builder.timestamps;
    }

    public BatchPutAssetPropertyValueErrorCode errorCode() {
        return BatchPutAssetPropertyValueErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public List<TimeInNanos> timestamps() {
        return this.timestamps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyError)) {
            return false;
        }
        BatchPutAssetPropertyError other = (BatchPutAssetPropertyError)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.timestamps(), other.timestamps());
    }

    public String toString() {
        return ToString.builder((String)"BatchPutAssetPropertyError").add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("Timestamps", this.timestamps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyError, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;
        private List<TimeInNanos> timestamps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyError model) {
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.timestamps(model.timestamps);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchPutAssetPropertyValueErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<TimeInNanos.Builder> getTimestamps() {
            return this.timestamps != null ? (Collection)this.timestamps.stream().map(TimeInNanos::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder timestamps(Collection<TimeInNanos> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(TimeInNanos ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Consumer<TimeInNanos.Builder> ... timestamps) {
            this.timestamps(Stream.of(timestamps).map(c -> (TimeInNanos)((TimeInNanos.Builder)TimeInNanos.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimestamps(Collection<TimeInNanos.BuilderImpl> timestamps) {
            this.timestamps = TimestampsCopier.copyFromBuilder(timestamps);
        }

        public BatchPutAssetPropertyError build() {
            return new BatchPutAssetPropertyError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchPutAssetPropertyError> {
        public Builder errorCode(String var1);

        public Builder errorCode(BatchPutAssetPropertyValueErrorCode var1);

        public Builder errorMessage(String var1);

        public Builder timestamps(Collection<TimeInNanos> var1);

        public Builder timestamps(TimeInNanos ... var1);

        public Builder timestamps(Consumer<TimeInNanos.Builder> ... var1);
    }
}

