/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AssetState {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AssetState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AssetState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetState> knownValues() {
        return Stream.of(AssetState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

