/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionType {
    SITEWISE_DEFAULT_ENCRYPTION("SITEWISE_DEFAULT_ENCRYPTION"),
    KMS_BASED_ENCRYPTION("KMS_BASED_ENCRYPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncryptionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionType> knownValues() {
        return Stream.of(EncryptionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

