/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelName").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelName)).setter(CreateAssetModelRequest.setter(Builder::assetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelDescription").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelDescription)).setter(CreateAssetModelRequest.setter(Builder::assetModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build()}).build();
    private static final SdkField<List<AssetModelPropertyDefinition>> ASSET_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelProperties").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelProperties)).setter(CreateAssetModelRequest.setter(Builder::assetModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelHierarchyDefinition>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelHierarchies").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelHierarchies)).setter(CreateAssetModelRequest.setter(Builder::assetModelHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelHierarchyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetModelCompositeModelDefinition>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelCompositeModels").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::assetModelCompositeModels)).setter(CreateAssetModelRequest.setter(Builder::assetModelCompositeModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelCompositeModelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::clientToken)).setter(CreateAssetModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAssetModelRequest.getter(CreateAssetModelRequest::tags)).setter(CreateAssetModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_NAME_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_COMPOSITE_MODELS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String assetModelName;
    private final String assetModelDescription;
    private final List<AssetModelPropertyDefinition> assetModelProperties;
    private final List<AssetModelHierarchyDefinition> assetModelHierarchies;
    private final List<AssetModelCompositeModelDefinition> assetModelCompositeModels;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public String assetModelName() {
        return this.assetModelName;
    }

    public String assetModelDescription() {
        return this.assetModelDescription;
    }

    public boolean hasAssetModelProperties() {
        return this.assetModelProperties != null && !(this.assetModelProperties instanceof SdkAutoConstructList);
    }

    public List<AssetModelPropertyDefinition> assetModelProperties() {
        return this.assetModelProperties;
    }

    public boolean hasAssetModelHierarchies() {
        return this.assetModelHierarchies != null && !(this.assetModelHierarchies instanceof SdkAutoConstructList);
    }

    public List<AssetModelHierarchyDefinition> assetModelHierarchies() {
        return this.assetModelHierarchies;
    }

    public boolean hasAssetModelCompositeModels() {
        return this.assetModelCompositeModels != null && !(this.assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    public List<AssetModelCompositeModelDefinition> assetModelCompositeModels() {
        return this.assetModelCompositeModels;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelProperties() ? this.assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetModelRequest)) {
            return false;
        }
        CreateAssetModelRequest other = (CreateAssetModelRequest)((Object)obj);
        return Objects.equals(this.assetModelName(), other.assetModelName()) && Objects.equals(this.assetModelDescription(), other.assetModelDescription()) && this.hasAssetModelProperties() == other.hasAssetModelProperties() && Objects.equals(this.assetModelProperties(), other.assetModelProperties()) && this.hasAssetModelHierarchies() == other.hasAssetModelHierarchies() && Objects.equals(this.assetModelHierarchies(), other.assetModelHierarchies()) && this.hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels() && Objects.equals(this.assetModelCompositeModels(), other.assetModelCompositeModels()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssetModelRequest").add("AssetModelName", (Object)this.assetModelName()).add("AssetModelDescription", (Object)this.assetModelDescription()).add("AssetModelProperties", this.hasAssetModelProperties() ? this.assetModelProperties() : null).add("AssetModelHierarchies", this.hasAssetModelHierarchies() ? this.assetModelHierarchies() : null).add("AssetModelCompositeModels", this.hasAssetModelCompositeModels() ? this.assetModelCompositeModels() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelName": {
                return Optional.ofNullable(clazz.cast(this.assetModelName()));
            }
            case "assetModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetModelDescription()));
            }
            case "assetModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetModelProperties()));
            }
            case "assetModelHierarchies": {
                return Optional.ofNullable(clazz.cast(this.assetModelHierarchies()));
            }
            case "assetModelCompositeModels": {
                return Optional.ofNullable(clazz.cast(this.assetModelCompositeModels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetModelRequest, T> g) {
        return obj -> g.apply((CreateAssetModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelName;
        private String assetModelDescription;
        private List<AssetModelPropertyDefinition> assetModelProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelHierarchyDefinition> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<AssetModelCompositeModelDefinition> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetModelRequest model) {
            super(model);
            this.assetModelName(model.assetModelName);
            this.assetModelDescription(model.assetModelDescription);
            this.assetModelProperties(model.assetModelProperties);
            this.assetModelHierarchies(model.assetModelHierarchies);
            this.assetModelCompositeModels(model.assetModelCompositeModels);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getAssetModelName() {
            return this.assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        public final String getAssetModelDescription() {
            return this.assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        public final Collection<AssetModelPropertyDefinition.Builder> getAssetModelProperties() {
            if (this.assetModelProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelProperties != null ? (Collection)this.assetModelProperties.stream().map(AssetModelPropertyDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelPropertyDefinition> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelPropertyDefinition ... assetModelProperties) {
            this.assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... assetModelProperties) {
            this.assetModelProperties(Stream.of(assetModelProperties).map(c -> (AssetModelPropertyDefinition)((AssetModelPropertyDefinition.Builder)AssetModelPropertyDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelProperties(Collection<AssetModelPropertyDefinition.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copyFromBuilder(assetModelProperties);
        }

        public final Collection<AssetModelHierarchyDefinition.Builder> getAssetModelHierarchies() {
            if (this.assetModelHierarchies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelHierarchies != null ? (Collection)this.assetModelHierarchies.stream().map(AssetModelHierarchyDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchyDefinition ... assetModelHierarchies) {
            this.assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder> ... assetModelHierarchies) {
            this.assetModelHierarchies(Stream.of(assetModelHierarchies).map(c -> (AssetModelHierarchyDefinition)((AssetModelHierarchyDefinition.Builder)AssetModelHierarchyDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchyDefinition.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copyFromBuilder(assetModelHierarchies);
        }

        public final Collection<AssetModelCompositeModelDefinition.Builder> getAssetModelCompositeModels() {
            if (this.assetModelCompositeModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetModelCompositeModels != null ? (Collection)this.assetModelCompositeModels.stream().map(AssetModelCompositeModelDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModelDefinition ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModelDefinition.Builder> ... assetModelCompositeModels) {
            this.assetModelCompositeModels(Stream.of(assetModelCompositeModels).map(c -> (AssetModelCompositeModelDefinition)((AssetModelCompositeModelDefinition.Builder)AssetModelCompositeModelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModelDefinition.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetModelRequest build() {
            return new CreateAssetModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetModelRequest> {
        public Builder assetModelName(String var1);

        public Builder assetModelDescription(String var1);

        public Builder assetModelProperties(Collection<AssetModelPropertyDefinition> var1);

        public Builder assetModelProperties(AssetModelPropertyDefinition ... var1);

        public Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder> ... var1);

        public Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> var1);

        public Builder assetModelHierarchies(AssetModelHierarchyDefinition ... var1);

        public Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder> ... var1);

        public Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> var1);

        public Builder assetModelCompositeModels(AssetModelCompositeModelDefinition ... var1);

        public Builder assetModelCompositeModels(Consumer<AssetModelCompositeModelDefinition.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

