/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.services.iotsitewise.model.PropertyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetModelPropertyDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetModelPropertyDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetModelPropertyDefinition.getter(AssetModelPropertyDefinition::name)).setter(AssetModelPropertyDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(AssetModelPropertyDefinition.getter(AssetModelPropertyDefinition::dataTypeAsString)).setter(AssetModelPropertyDefinition.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(AssetModelPropertyDefinition.getter(AssetModelPropertyDefinition::unit)).setter(AssetModelPropertyDefinition.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("type").getter(AssetModelPropertyDefinition.getter(AssetModelPropertyDefinition::type)).setter(AssetModelPropertyDefinition.setter(Builder::type)).constructor(PropertyType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD, UNIT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dataType;
    private final String unit;
    private final PropertyType type;

    private AssetModelPropertyDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.unit = builder.unit;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public String dataTypeAsString() {
        return this.dataType;
    }

    public String unit() {
        return this.unit;
    }

    public PropertyType type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelPropertyDefinition)) {
            return false;
        }
        AssetModelPropertyDefinition other = (AssetModelPropertyDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.type(), other.type());
    }

    public String toString() {
        return ToString.builder((String)"AssetModelPropertyDefinition").add("Name", (Object)this.name()).add("DataType", (Object)this.dataTypeAsString()).add("Unit", (Object)this.unit()).add("Type", (Object)this.type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetModelPropertyDefinition, T> g) {
        return obj -> g.apply((AssetModelPropertyDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dataType;
        private String unit;
        private PropertyType type;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelPropertyDefinition model) {
            this.name(model.name);
            this.dataType(model.dataType);
            this.unit(model.unit);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final PropertyType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        public AssetModelPropertyDefinition build() {
            return new AssetModelPropertyDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetModelPropertyDefinition> {
        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder unit(String var1);

        public Builder type(PropertyType var1);

        default public Builder type(Consumer<PropertyType.Builder> type) {
            return this.type((PropertyType)((PropertyType.Builder)PropertyType.builder().applyMutation(type)).build());
        }
    }
}

