/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.AssetStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateAssetResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(CreateAssetResponse.getter(CreateAssetResponse::assetId)).setter(CreateAssetResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetArn").getter(CreateAssetResponse.getter(CreateAssetResponse::assetArn)).setter(CreateAssetResponse.setter(Builder::assetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetArn").build()}).build();
    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetStatus").getter(CreateAssetResponse.getter(CreateAssetResponse::assetStatus)).setter(CreateAssetResponse.setter(Builder::assetStatus)).constructor(AssetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_ARN_FIELD, ASSET_STATUS_FIELD));
    private final String assetId;
    private final String assetArn;
    private final AssetStatus assetStatus;

    private CreateAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetArn = builder.assetArn;
        this.assetStatus = builder.assetStatus;
    }

    public String assetId() {
        return this.assetId;
    }

    public String assetArn() {
        return this.assetArn;
    }

    public AssetStatus assetStatus() {
        return this.assetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetResponse)) {
            return false;
        }
        CreateAssetResponse other = (CreateAssetResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetArn(), other.assetArn()) && Objects.equals(this.assetStatus(), other.assetStatus());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssetResponse").add("AssetId", (Object)this.assetId()).add("AssetArn", (Object)this.assetArn()).add("AssetStatus", (Object)this.assetStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetArn": {
                return Optional.ofNullable(clazz.cast(this.assetArn()));
            }
            case "assetStatus": {
                return Optional.ofNullable(clazz.cast(this.assetStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetResponse, T> g) {
        return obj -> g.apply((CreateAssetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetArn;
        private AssetStatus assetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.assetArn(model.assetArn);
            this.assetStatus(model.assetStatus);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getAssetArn() {
            return this.assetArn;
        }

        @Override
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        public final AssetStatus.Builder getAssetStatus() {
            return this.assetStatus != null ? this.assetStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        public CreateAssetResponse build() {
            return new CreateAssetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetResponse> {
        public Builder assetId(String var1);

        public Builder assetArn(String var1);

        public Builder assetStatus(AssetStatus var1);

        default public Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return this.assetStatus((AssetStatus)((AssetStatus.Builder)AssetStatus.builder().applyMutation(assetStatus)).build());
        }
    }
}

