/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutAssetPropertyValueResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, BatchPutAssetPropertyValueResponse> {
    private static final SdkField<List<BatchPutAssetPropertyErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorEntries").getter(BatchPutAssetPropertyValueResponse.getter(BatchPutAssetPropertyValueResponse::errorEntries)).setter(BatchPutAssetPropertyValueResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutAssetPropertyErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD));
    private final List<BatchPutAssetPropertyErrorEntry> errorEntries;

    private BatchPutAssetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
    }

    public boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public List<BatchPutAssetPropertyErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorEntries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyValueResponse)) {
            return false;
        }
        BatchPutAssetPropertyValueResponse other = (BatchPutAssetPropertyValueResponse)((Object)obj);
        return Objects.equals(this.errorEntries(), other.errorEntries());
    }

    public String toString() {
        return ToString.builder((String)"BatchPutAssetPropertyValueResponse").add("ErrorEntries", this.errorEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyValueResponse, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<BatchPutAssetPropertyErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyValueResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
        }

        public final Collection<BatchPutAssetPropertyErrorEntry.Builder> getErrorEntries() {
            return this.errorEntries != null ? (Collection)this.errorEntries.stream().map(BatchPutAssetPropertyErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorEntries(Collection<BatchPutAssetPropertyErrorEntry> errorEntries) {
            this.errorEntries = BatchPutAssetPropertyErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchPutAssetPropertyErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchPutAssetPropertyErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchPutAssetPropertyErrorEntry)((BatchPutAssetPropertyErrorEntry.Builder)BatchPutAssetPropertyErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrorEntries(Collection<BatchPutAssetPropertyErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchPutAssetPropertyErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public BatchPutAssetPropertyValueResponse build() {
            return new BatchPutAssetPropertyValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutAssetPropertyValueResponse> {
        public Builder errorEntries(Collection<BatchPutAssetPropertyErrorEntry> var1);

        public Builder errorEntries(BatchPutAssetPropertyErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchPutAssetPropertyErrorEntry.Builder> ... var1);
    }
}

