/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary;
import software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeGatewayResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayId)).setter(DescribeGatewayResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayName)).setter(DescribeGatewayResponse.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayArn)).setter(DescribeGatewayResponse.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<GatewayPlatform> GATEWAY_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayPlatform)).setter(DescribeGatewayResponse.setter(Builder::gatewayPlatform)).constructor(GatewayPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayPlatform").build()}).build();
    private static final SdkField<List<GatewayCapabilitySummary>> GATEWAY_CAPABILITY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::gatewayCapabilitySummaries)).setter(DescribeGatewayResponse.setter(Builder::gatewayCapabilitySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayCapabilitySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayCapabilitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::creationDate)).setter(DescribeGatewayResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeGatewayResponse.getter(DescribeGatewayResponse::lastUpdateDate)).setter(DescribeGatewayResponse.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_ARN_FIELD, GATEWAY_PLATFORM_FIELD, GATEWAY_CAPABILITY_SUMMARIES_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));
    private final String gatewayId;
    private final String gatewayName;
    private final String gatewayArn;
    private final GatewayPlatform gatewayPlatform;
    private final List<GatewayCapabilitySummary> gatewayCapabilitySummaries;
    private final Instant creationDate;
    private final Instant lastUpdateDate;

    private DescribeGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayPlatform = builder.gatewayPlatform;
        this.gatewayCapabilitySummaries = builder.gatewayCapabilitySummaries;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String gatewayName() {
        return this.gatewayName;
    }

    public String gatewayArn() {
        return this.gatewayArn;
    }

    public GatewayPlatform gatewayPlatform() {
        return this.gatewayPlatform;
    }

    public boolean hasGatewayCapabilitySummaries() {
        return this.gatewayCapabilitySummaries != null && !(this.gatewayCapabilitySummaries instanceof SdkAutoConstructList);
    }

    public List<GatewayCapabilitySummary> gatewayCapabilitySummaries() {
        return this.gatewayCapabilitySummaries;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayCapabilitySummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayResponse)) {
            return false;
        }
        DescribeGatewayResponse other = (DescribeGatewayResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayPlatform(), other.gatewayPlatform()) && Objects.equals(this.gatewayCapabilitySummaries(), other.gatewayCapabilitySummaries()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGatewayResponse").add("GatewayId", (Object)this.gatewayId()).add("GatewayName", (Object)this.gatewayName()).add("GatewayArn", (Object)this.gatewayArn()).add("GatewayPlatform", (Object)this.gatewayPlatform()).add("GatewayCapabilitySummaries", this.gatewayCapabilitySummaries()).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "gatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "gatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "gatewayPlatform": {
                return Optional.ofNullable(clazz.cast(this.gatewayPlatform()));
            }
            case "gatewayCapabilitySummaries": {
                return Optional.ofNullable(clazz.cast(this.gatewayCapabilitySummaries()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayResponse, T> g) {
        return obj -> g.apply((DescribeGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String gatewayName;
        private String gatewayArn;
        private GatewayPlatform gatewayPlatform;
        private List<GatewayCapabilitySummary> gatewayCapabilitySummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.gatewayName(model.gatewayName);
            this.gatewayArn(model.gatewayArn);
            this.gatewayPlatform(model.gatewayPlatform);
            this.gatewayCapabilitySummaries(model.gatewayCapabilitySummaries);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        public final GatewayPlatform.Builder getGatewayPlatform() {
            return this.gatewayPlatform != null ? this.gatewayPlatform.toBuilder() : null;
        }

        @Override
        public final Builder gatewayPlatform(GatewayPlatform gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        public final void setGatewayPlatform(GatewayPlatform.BuilderImpl gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform != null ? gatewayPlatform.build() : null;
        }

        public final Collection<GatewayCapabilitySummary.Builder> getGatewayCapabilitySummaries() {
            return this.gatewayCapabilitySummaries != null ? (Collection)this.gatewayCapabilitySummaries.stream().map(GatewayCapabilitySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copy(gatewayCapabilitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(GatewayCapabilitySummary ... gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries(Arrays.asList(gatewayCapabilitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder> ... gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries(Stream.of(gatewayCapabilitySummaries).map(c -> (GatewayCapabilitySummary)((GatewayCapabilitySummary.Builder)GatewayCapabilitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayCapabilitySummaries(Collection<GatewayCapabilitySummary.BuilderImpl> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copyFromBuilder(gatewayCapabilitySummaries);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public DescribeGatewayResponse build() {
            return new DescribeGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayResponse> {
        public Builder gatewayId(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayArn(String var1);

        public Builder gatewayPlatform(GatewayPlatform var1);

        default public Builder gatewayPlatform(Consumer<GatewayPlatform.Builder> gatewayPlatform) {
            return this.gatewayPlatform((GatewayPlatform)((GatewayPlatform.Builder)GatewayPlatform.builder().applyMutation(gatewayPlatform)).build());
        }

        public Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> var1);

        public Builder gatewayCapabilitySummaries(GatewayCapabilitySummary ... var1);

        public Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder> ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

