/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.services.iotsitewise.model.PropertyNotification;
import software.amazon.awssdk.services.iotsitewise.model.PropertyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Property
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Property> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Property.getter(Property::id)).setter(Property.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Property.getter(Property::name)).setter(Property.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Property.getter(Property::alias)).setter(Property.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Property.getter(Property::notification)).setter(Property.setter(Builder::notification)).constructor(PropertyNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Property.getter(Property::dataTypeAsString)).setter(Property.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Property.getter(Property::unit)).setter(Property.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Property.getter(Property::type)).setter(Property.setter(Builder::type)).constructor(PropertyType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ALIAS_FIELD, NOTIFICATION_FIELD, DATA_TYPE_FIELD, UNIT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String alias;
    private final PropertyNotification notification;
    private final String dataType;
    private final String unit;
    private final PropertyType type;

    private Property(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.alias = builder.alias;
        this.notification = builder.notification;
        this.dataType = builder.dataType;
        this.unit = builder.unit;
        this.type = builder.type;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String alias() {
        return this.alias;
    }

    public PropertyNotification notification() {
        return this.notification;
    }

    public PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public String dataTypeAsString() {
        return this.dataType;
    }

    public String unit() {
        return this.unit;
    }

    public PropertyType type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.type(), other.type());
    }

    public String toString() {
        return ToString.builder((String)"Property").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Alias", (Object)this.alias()).add("Notification", (Object)this.notification()).add("DataType", (Object)this.dataTypeAsString()).add("Unit", (Object)this.unit()).add("Type", (Object)this.type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String alias;
        private PropertyNotification notification;
        private String dataType;
        private String unit;
        private PropertyType type;

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            this.id(model.id);
            this.name(model.name);
            this.alias(model.alias);
            this.notification(model.notification);
            this.dataType(model.dataType);
            this.unit(model.unit);
            this.type(model.type);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final PropertyNotification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final PropertyType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        public Property build() {
            return new Property(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Property> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder alias(String var1);

        public Builder notification(PropertyNotification var1);

        default public Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return this.notification((PropertyNotification)((PropertyNotification.Builder)PropertyNotification.builder().applyMutation(notification)).build());
        }

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder unit(String var1);

        public Builder type(PropertyType var1);

        default public Builder type(Consumer<PropertyType.Builder> type) {
            return this.type((PropertyType)((PropertyType.Builder)PropertyType.builder().applyMutation(type)).build());
        }
    }
}

