/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProjectAssetsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListProjectAssetsResponse.Builder, ListProjectAssetsResponse> {
    private static final SdkField<List<String>> ASSET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListProjectAssetsResponse::assetIds))
            .setter(setter(Builder::assetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProjectAssetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> assetIds;

    private final String nextToken;

    private ListProjectAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.assetIds = builder.assetIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AssetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAssetIds() {
        return assetIds != null && !(assetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the IDs of each asset associated with the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the IDs of each asset associated with the project.
     */
    public List<String> assetIds() {
        return assetIds;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectAssetsResponse)) {
            return false;
        }
        ListProjectAssetsResponse other = (ListProjectAssetsResponse) obj;
        return Objects.equals(assetIds(), other.assetIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProjectAssetsResponse").add("AssetIds", assetIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetIds":
            return Optional.ofNullable(clazz.cast(assetIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectAssetsResponse, T> g) {
        return obj -> g.apply((ListProjectAssetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProjectAssetsResponse> {
        /**
         * <p>
         * A list that contains the IDs of each asset associated with the project.
         * </p>
         * 
         * @param assetIds
         *        A list that contains the IDs of each asset associated with the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(Collection<String> assetIds);

        /**
         * <p>
         * A list that contains the IDs of each asset associated with the project.
         * </p>
         * 
         * @param assetIds
         *        A list that contains the IDs of each asset associated with the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(String... assetIds);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<String> assetIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectAssetsResponse model) {
            super(model);
            assetIds(model.assetIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAssetIds() {
            return assetIds;
        }

        @Override
        public final Builder assetIds(Collection<String> assetIds) {
            this.assetIds = AssetIDsCopier.copy(assetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIds(String... assetIds) {
            assetIds(Arrays.asList(assetIds));
            return this;
        }

        public final void setAssetIds(Collection<String> assetIds) {
            this.assetIds = AssetIDsCopier.copy(assetIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProjectAssetsResponse build() {
            return new ListProjectAssetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
