/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListDashboardsResponse.Builder, ListDashboardsResponse> {
    private static final SdkField<List<DashboardSummary>> DASHBOARD_SUMMARIES_FIELD = SdkField
            .<List<DashboardSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDashboardsResponse::dashboardSummaries))
            .setter(setter(Builder::dashboardSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDashboardsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DashboardSummary> dashboardSummaries;

    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardSummaries = builder.dashboardSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DashboardSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDashboardSummaries() {
        return dashboardSummaries != null && !(dashboardSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each dashboard in the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDashboardSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each dashboard in the project.
     */
    public List<DashboardSummary> dashboardSummaries() {
        return dashboardSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse) obj;
        return Objects.equals(dashboardSummaries(), other.dashboardSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDashboardsResponse").add("DashboardSummaries", dashboardSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dashboardSummaries":
            return Optional.ofNullable(clazz.cast(dashboardSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsResponse, T> g) {
        return obj -> g.apply((ListDashboardsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDashboardsResponse> {
        /**
         * <p>
         * A list that summarizes each dashboard in the project.
         * </p>
         * 
         * @param dashboardSummaries
         *        A list that summarizes each dashboard in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardSummaries(Collection<DashboardSummary> dashboardSummaries);

        /**
         * <p>
         * A list that summarizes each dashboard in the project.
         * </p>
         * 
         * @param dashboardSummaries
         *        A list that summarizes each dashboard in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardSummaries(DashboardSummary... dashboardSummaries);

        /**
         * <p>
         * A list that summarizes each dashboard in the project.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DashboardSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #dashboardSummaries(List<DashboardSummary>)}.
         * 
         * @param dashboardSummaries
         *        a consumer that will call methods on {@link List<DashboardSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardSummaries(List<DashboardSummary>)
         */
        Builder dashboardSummaries(Consumer<DashboardSummary.Builder>... dashboardSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<DashboardSummary> dashboardSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            super(model);
            dashboardSummaries(model.dashboardSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<DashboardSummary.Builder> getDashboardSummaries() {
            return dashboardSummaries != null ? dashboardSummaries.stream().map(DashboardSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardSummaries(Collection<DashboardSummary> dashboardSummaries) {
            this.dashboardSummaries = DashboardSummariesCopier.copy(dashboardSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaries(DashboardSummary... dashboardSummaries) {
            dashboardSummaries(Arrays.asList(dashboardSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaries(Consumer<DashboardSummary.Builder>... dashboardSummaries) {
            dashboardSummaries(Stream.of(dashboardSummaries).map(c -> DashboardSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardSummaries(Collection<DashboardSummary.BuilderImpl> dashboardSummaries) {
            this.dashboardSummaries = DashboardSummariesCopier.copyFromBuilder(dashboardSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
