/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an AWS SSO identity ID for a user or group.
 * </p>
 * <note>
 * <p>
 * Currently, you can't use AWS APIs to retrieve AWS SSO identity IDs. You can find the AWS SSO identity IDs in the URL
 * of user and group pages in the <a href="https://console.aws.amazon.com/singlesignon">AWS SSO console</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Identity implements SdkPojo, Serializable, ToCopyableBuilder<Identity.Builder, Identity> {
    private static final SdkField<UserIdentity> USER_FIELD = SdkField.<UserIdentity> builder(MarshallingType.SDK_POJO)
            .getter(getter(Identity::user)).setter(setter(Builder::user)).constructor(UserIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<GroupIdentity> GROUP_FIELD = SdkField.<GroupIdentity> builder(MarshallingType.SDK_POJO)
            .getter(getter(Identity::group)).setter(setter(Builder::group)).constructor(GroupIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserIdentity user;

    private final GroupIdentity group;

    private Identity(BuilderImpl builder) {
        this.user = builder.user;
        this.group = builder.group;
    }

    /**
     * <p>
     * A user identity.
     * </p>
     * 
     * @return A user identity.
     */
    public UserIdentity user() {
        return user;
    }

    /**
     * <p>
     * A group identity.
     * </p>
     * 
     * @return A group identity.
     */
    public GroupIdentity group() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(group(), other.group());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Identity").add("User", user()).add("Group", group()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Identity> {
        /**
         * <p>
         * A user identity.
         * </p>
         * 
         * @param user
         *        A user identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserIdentity user);

        /**
         * <p>
         * A user identity.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentity.Builder} avoiding the need to
         * create one manually via {@link UserIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #user(UserIdentity)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserIdentity)
         */
        default Builder user(Consumer<UserIdentity.Builder> user) {
            return user(UserIdentity.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * A group identity.
         * </p>
         * 
         * @param group
         *        A group identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(GroupIdentity group);

        /**
         * <p>
         * A group identity.
         * </p>
         * This is a convenience that creates an instance of the {@link GroupIdentity.Builder} avoiding the need to
         * create one manually via {@link GroupIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #group(GroupIdentity)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link GroupIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(GroupIdentity)
         */
        default Builder group(Consumer<GroupIdentity.Builder> group) {
            return group(GroupIdentity.builder().applyMutation(group).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserIdentity user;

        private GroupIdentity group;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            user(model.user);
            group(model.group);
        }

        public final UserIdentity.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        @Override
        public final Builder user(UserIdentity user) {
            this.user = user;
            return this;
        }

        public final void setUser(UserIdentity.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final GroupIdentity.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        @Override
        public final Builder group(GroupIdentity group) {
            this.group = group;
            return this;
        }

        public final void setGroup(GroupIdentity.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        @Override
        public Identity build() {
            return new Identity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
