/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssetPropertyValueRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<GetAssetPropertyValueRequest.Builder, GetAssetPropertyValueRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssetPropertyValueRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssetPropertyValueRequest::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssetPropertyValueRequest::propertyAlias)).setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD));

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private GetAssetPropertyValueRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The property alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping Industrial
     * Data Streams to Asset Properties</a> in the <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The property alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         Industrial Data Streams to Asset Properties</a> in the <i>AWS IoT SiteWise User Guide</i>.
     */
    public String propertyAlias() {
        return propertyAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetPropertyValueRequest)) {
            return false;
        }
        GetAssetPropertyValueRequest other = (GetAssetPropertyValueRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(propertyId(), other.propertyId())
                && Objects.equals(propertyAlias(), other.propertyAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAssetPropertyValueRequest").add("AssetId", assetId()).add("PropertyId", propertyId())
                .add("PropertyAlias", propertyAlias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetPropertyValueRequest, T> g) {
        return obj -> g.apply((GetAssetPropertyValueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAssetPropertyValueRequest> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The property alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping Industrial
         * Data Streams to Asset Properties</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param propertyAlias
         *        The property alias that identifies the property, such as an OPC-UA server data stream path (for
         *        example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        Industrial Data Streams to Asset Properties</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetPropertyValueRequest model) {
            super(model);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetPropertyValueRequest build() {
            return new GetAssetPropertyValueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
