/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayCapabilityConfigurationRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DescribeGatewayCapabilityConfigurationRequest.Builder, DescribeGatewayCapabilityConfigurationRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationRequest::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayCapabilityConfigurationRequest::capabilityNamespace))
            .setter(setter(Builder::capabilityNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("capabilityNamespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            CAPABILITY_NAMESPACE_FIELD));

    private final String gatewayId;

    private final String capabilityNamespace;

    private DescribeGatewayCapabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.capabilityNamespace = builder.capabilityNamespace;
    }

    /**
     * <p>
     * The ID of the gateway that defines the capability configuration.
     * </p>
     * 
     * @return The ID of the gateway that defines the capability configuration.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The namespace of the capability configuration. For example, if you configure OPC-UA sources from the AWS IoT
     * SiteWise console, your OPC-UA capability configuration has the namespace
     * <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.
     * </p>
     * 
     * @return The namespace of the capability configuration. For example, if you configure OPC-UA sources from the AWS
     *         IoT SiteWise console, your OPC-UA capability configuration has the namespace
     *         <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
     *         <code>1</code>.
     */
    public String capabilityNamespace() {
        return capabilityNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityNamespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayCapabilityConfigurationRequest)) {
            return false;
        }
        DescribeGatewayCapabilityConfigurationRequest other = (DescribeGatewayCapabilityConfigurationRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(capabilityNamespace(), other.capabilityNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGatewayCapabilityConfigurationRequest").add("GatewayId", gatewayId())
                .add("CapabilityNamespace", capabilityNamespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "capabilityNamespace":
            return Optional.ofNullable(clazz.cast(capabilityNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayCapabilityConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeGatewayCapabilityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGatewayCapabilityConfigurationRequest> {
        /**
         * <p>
         * The ID of the gateway that defines the capability configuration.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway that defines the capability configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The namespace of the capability configuration. For example, if you configure OPC-UA sources from the AWS IoT
         * SiteWise console, your OPC-UA capability configuration has the namespace
         * <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
         * <code>1</code>.
         * </p>
         * 
         * @param capabilityNamespace
         *        The namespace of the capability configuration. For example, if you configure OPC-UA sources from the
         *        AWS IoT SiteWise console, your OPC-UA capability configuration has the namespace
         *        <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
         *        <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityNamespace(String capabilityNamespace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String gatewayId;

        private String capabilityNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayCapabilityConfigurationRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            capabilityNamespace(model.capabilityNamespace);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getCapabilityNamespace() {
            return capabilityNamespace;
        }

        @Override
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGatewayCapabilityConfigurationRequest build() {
            return new DescribeGatewayCapabilityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
