/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePortalResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DeletePortalResponse.Builder, DeletePortalResponse> {
    private static final SdkField<PortalStatus> PORTAL_STATUS_FIELD = SdkField.<PortalStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeletePortalResponse::portalStatus)).setter(setter(Builder::portalStatus))
            .constructor(PortalStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_STATUS_FIELD));

    private final PortalStatus portalStatus;

    private DeletePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalStatus = builder.portalStatus;
    }

    /**
     * <p>
     * The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this
     * operation) and any error message.
     * </p>
     * 
     * @return The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this
     *         operation) and any error message.
     */
    public PortalStatus portalStatus() {
        return portalStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePortalResponse)) {
            return false;
        }
        DeletePortalResponse other = (DeletePortalResponse) obj;
        return Objects.equals(portalStatus(), other.portalStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePortalResponse").add("PortalStatus", portalStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePortalResponse, T> g) {
        return obj -> g.apply((DeletePortalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePortalResponse> {
        /**
         * <p>
         * The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * 
         * @param portalStatus
         *        The status of the portal, which contains a state (<code>DELETING</code> after successfully calling
         *        this operation) and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link PortalStatus.Builder} avoiding the need to
         * create one manually via {@link PortalStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortalStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #portalStatus(PortalStatus)}.
         * 
         * @param portalStatus
         *        a consumer that will call methods on {@link PortalStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalStatus(PortalStatus)
         */
        default Builder portalStatus(Consumer<PortalStatus.Builder> portalStatus) {
            return portalStatus(PortalStatus.builder().applyMutation(portalStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private PortalStatus portalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePortalResponse model) {
            super(model);
            portalStatus(model.portalStatus);
        }

        public final PortalStatus.Builder getPortalStatus() {
            return portalStatus != null ? portalStatus.toBuilder() : null;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        public final void setPortalStatus(PortalStatus.BuilderImpl portalStatus) {
            this.portalStatus = portalStatus != null ? portalStatus.build() : null;
        }

        @Override
        public DeletePortalResponse build() {
            return new DeletePortalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
