/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAssetModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DeleteAssetModelResponse.Builder, DeleteAssetModelResponse> {
    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField
            .<AssetModelStatus> builder(MarshallingType.SDK_POJO).getter(getter(DeleteAssetModelResponse::assetModelStatus))
            .setter(setter(Builder::assetModelStatus)).constructor(AssetModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_STATUS_FIELD));

    private final AssetModelStatus assetModelStatus;

    private DeleteAssetModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelStatus = builder.assetModelStatus;
    }

    /**
     * <p>
     * The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this
     * operation) and any error message.
     * </p>
     * 
     * @return The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling
     *         this operation) and any error message.
     */
    public AssetModelStatus assetModelStatus() {
        return assetModelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssetModelResponse)) {
            return false;
        }
        DeleteAssetModelResponse other = (DeleteAssetModelResponse) obj;
        return Objects.equals(assetModelStatus(), other.assetModelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAssetModelResponse").add("AssetModelStatus", assetModelStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelStatus":
            return Optional.ofNullable(clazz.cast(assetModelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssetModelResponse, T> g) {
        return obj -> g.apply((DeleteAssetModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAssetModelResponse> {
        /**
         * <p>
         * The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * 
         * @param assetModelStatus
         *        The status of the asset model, which contains a state (<code>DELETING</code> after successfully
         *        calling this operation) and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelStatus(AssetModelStatus assetModelStatus);

        /**
         * <p>
         * The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetModelStatus.Builder} avoiding the need to
         * create one manually via {@link AssetModelStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetModelStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #assetModelStatus(AssetModelStatus)}.
         * 
         * @param assetModelStatus
         *        a consumer that will call methods on {@link AssetModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelStatus(AssetModelStatus)
         */
        default Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return assetModelStatus(AssetModelStatus.builder().applyMutation(assetModelStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssetModelResponse model) {
            super(model);
            assetModelStatus(model.assetModelStatus);
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return assetModelStatus != null ? assetModelStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public DeleteAssetModelResponse build() {
            return new DeleteAssetModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
