/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortalRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreatePortalRequest.Builder, CreatePortalRequest> {
    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortalRequest::portalName)).setter(setter(Builder::portalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()).build();

    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortalRequest::portalDescription)).setter(setter(Builder::portalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()).build();

    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortalRequest::portalContactEmail)).setter(setter(Builder::portalContactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortalRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ImageFile> PORTAL_LOGO_IMAGE_FILE_FIELD = SdkField
            .<ImageFile> builder(MarshallingType.SDK_POJO).getter(getter(CreatePortalRequest::portalLogoImageFile))
            .setter(setter(Builder::portalLogoImageFile)).constructor(ImageFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImageFile").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortalRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreatePortalRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_NAME_FIELD,
            PORTAL_DESCRIPTION_FIELD, PORTAL_CONTACT_EMAIL_FIELD, CLIENT_TOKEN_FIELD, PORTAL_LOGO_IMAGE_FILE_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD));

    private final String portalName;

    private final String portalDescription;

    private final String portalContactEmail;

    private final String clientToken;

    private final ImageFile portalLogoImageFile;

    private final String roleArn;

    private final Map<String, String> tags;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalContactEmail = builder.portalContactEmail;
        this.clientToken = builder.clientToken;
        this.portalLogoImageFile = builder.portalLogoImageFile;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A friendly name for the portal.
     * </p>
     * 
     * @return A friendly name for the portal.
     */
    public String portalName() {
        return portalName;
    }

    /**
     * <p>
     * A description for the portal.
     * </p>
     * 
     * @return A description for the portal.
     */
    public String portalDescription() {
        return portalDescription;
    }

    /**
     * <p>
     * The AWS administrator's contact email address.
     * </p>
     * 
     * @return The AWS administrator's contact email address.
     */
    public String portalContactEmail() {
        return portalContactEmail;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark
     * background.
     * </p>
     * 
     * @return A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on
     *         a dark background.
     */
    public ImageFile portalLogoImageFile() {
        return portalLogoImageFile;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
     * role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles
     * for AWS IoT SiteWise Monitor</a> in the <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
     *         service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     *         roles for AWS IoT SiteWise Monitor</a> in the <i>AWS IoT SiteWise User Guide</i>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the portal. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise
     * resources</a> in the <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the portal. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT
     *         SiteWise resources</a> in the <i>AWS IoT SiteWise User Guide</i>.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalName());
        hashCode = 31 * hashCode + Objects.hashCode(portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(portalLogoImageFile());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest) obj;
        return Objects.equals(portalName(), other.portalName()) && Objects.equals(portalDescription(), other.portalDescription())
                && Objects.equals(portalContactEmail(), other.portalContactEmail())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(portalLogoImageFile(), other.portalLogoImageFile())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePortalRequest").add("PortalName", portalName())
                .add("PortalDescription", portalDescription()).add("PortalContactEmail", portalContactEmail())
                .add("ClientToken", clientToken()).add("PortalLogoImageFile", portalLogoImageFile()).add("RoleArn", roleArn())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalName":
            return Optional.ofNullable(clazz.cast(portalName()));
        case "portalDescription":
            return Optional.ofNullable(clazz.cast(portalDescription()));
        case "portalContactEmail":
            return Optional.ofNullable(clazz.cast(portalContactEmail()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "portalLogoImageFile":
            return Optional.ofNullable(clazz.cast(portalLogoImageFile()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortalRequest> {
        /**
         * <p>
         * A friendly name for the portal.
         * </p>
         * 
         * @param portalName
         *        A friendly name for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalName(String portalName);

        /**
         * <p>
         * A description for the portal.
         * </p>
         * 
         * @param portalDescription
         *        A description for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalDescription(String portalDescription);

        /**
         * <p>
         * The AWS administrator's contact email address.
         * </p>
         * 
         * @param portalContactEmail
         *        The AWS administrator's contact email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalContactEmail(String portalContactEmail);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a
         * dark background.
         * </p>
         * 
         * @param portalLogoImageFile
         *        A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed
         *        on a dark background.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalLogoImageFile(ImageFile portalLogoImageFile);

        /**
         * <p>
         * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a
         * dark background.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageFile.Builder} avoiding the need to create
         * one manually via {@link ImageFile#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageFile.Builder#build()} is called immediately and its result
         * is passed to {@link #portalLogoImageFile(ImageFile)}.
         * 
         * @param portalLogoImageFile
         *        a consumer that will call methods on {@link ImageFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalLogoImageFile(ImageFile)
         */
        default Builder portalLogoImageFile(Consumer<ImageFile.Builder> portalLogoImageFile) {
            return portalLogoImageFile(ImageFile.builder().applyMutation(portalLogoImageFile).build());
        }

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
         * role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
         * roles for AWS IoT SiteWise Monitor</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
         *        service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using
         *        service roles for AWS IoT SiteWise Monitor</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the portal. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT
         * SiteWise resources</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the portal. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS
         *        IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String portalName;

        private String portalDescription;

        private String portalContactEmail;

        private String clientToken;

        private ImageFile portalLogoImageFile;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            portalName(model.portalName);
            portalDescription(model.portalDescription);
            portalContactEmail(model.portalContactEmail);
            clientToken(model.clientToken);
            portalLogoImageFile(model.portalLogoImageFile);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getPortalName() {
            return portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        public final String getPortalDescription() {
            return portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        public final String getPortalContactEmail() {
            return portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final ImageFile.Builder getPortalLogoImageFile() {
            return portalLogoImageFile != null ? portalLogoImageFile.toBuilder() : null;
        }

        @Override
        public final Builder portalLogoImageFile(ImageFile portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile;
            return this;
        }

        public final void setPortalLogoImageFile(ImageFile.BuilderImpl portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile != null ? portalLogoImageFile.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
