/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.MonitorErrorDetails;
import software.amazon.awssdk.services.iotsitewise.model.PortalState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortalStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortalStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PortalStatus.getter(PortalStatus::stateAsString)).setter(PortalStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<MonitorErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PortalStatus.getter(PortalStatus::error)).setter(PortalStatus.setter(Builder::error)).constructor(MonitorErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final MonitorErrorDetails error;

    private PortalStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.error = builder.error;
    }

    public PortalState state() {
        return PortalState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public MonitorErrorDetails error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalStatus)) {
            return false;
        }
        PortalStatus other = (PortalStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.error(), other.error());
    }

    public String toString() {
        return ToString.builder((String)"PortalStatus").add("State", (Object)this.stateAsString()).add("Error", (Object)this.error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortalStatus, T> g) {
        return obj -> g.apply((PortalStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private MonitorErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(PortalStatus model) {
            this.state(model.state);
            this.error(model.error);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PortalState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final MonitorErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(MonitorErrorDetails error) {
            this.error = error;
            return this;
        }

        public final void setError(MonitorErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public PortalStatus build() {
            return new PortalStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortalStatus> {
        public Builder state(String var1);

        public Builder state(PortalState var1);

        public Builder error(MonitorErrorDetails var1);

        default public Builder error(Consumer<MonitorErrorDetails.Builder> error) {
            return this.error((MonitorErrorDetails)((MonitorErrorDetails.Builder)MonitorErrorDetails.builder().applyMutation(error)).build());
        }
    }
}

