/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> LOCATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::locationUrl)).setter(Image.setter(Builder::locationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationUrl").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Image.getter(Image::lastUpdateDate)).setter(Image.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_URL_FIELD, LAST_UPDATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String locationUrl;
    private final Instant lastUpdateDate;

    private Image(BuilderImpl builder) {
        this.locationUrl = builder.locationUrl;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public String locationUrl() {
        return this.locationUrl;
    }

    public Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.locationUrl(), other.locationUrl()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public String toString() {
        return ToString.builder((String)"Image").add("LocationUrl", (Object)this.locationUrl()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationUrl": {
                return Optional.ofNullable(clazz.cast(this.locationUrl()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationUrl;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.locationUrl(model.locationUrl);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getLocationUrl() {
            return this.locationUrl;
        }

        @Override
        public final Builder locationUrl(String locationUrl) {
            this.locationUrl = locationUrl;
            return this;
        }

        public final void setLocationUrl(String locationUrl) {
            this.locationUrl = locationUrl;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder locationUrl(String var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

